/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.metamodel.criteria;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.hibernate.objectstore.metamodel.criteria.HibernateQueryCriteria;
import org.nakedobjects.plugins.hibernate.objectstore.metamodel.criteria.HibernateQueryData;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.query.Parameter;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.query.QueryPlaceholder;
import org.nakedobjects.plugins.remoting.shared.data.Data;
import org.nakedobjects.plugins.remoting.shared.data.KnownObjects;
import org.nakedobjects.plugins.remoting.shared.encoding.query.PersistenceQueryEncoderAbstract;
import org.nakedobjects.plugins.remoting.shared.encoding.query.data.PersistenceQueryData;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;
import org.nakedobjects.runtime.persistence.query.PersistenceQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateQueryEncoder
extends PersistenceQueryEncoderAbstract {
    public Class<HibernateQueryCriteria> getPersistenceQueryClass() {
        return HibernateQueryCriteria.class;
    }

    public PersistenceQueryData encode(PersistenceQuery criteria) {
        HibernateQueryCriteria hibernateCriteria = this.downcast(criteria);
        List<Parameter> parms = hibernateCriteria.getQuery().getParameters();
        NakedObjectSpecification[] specs = new NakedObjectSpecification[parms.size()];
        NakedObject[] objects = new NakedObject[parms.size()];
        for (int i = 0; i < parms.size(); ++i) {
            Parameter parm = parms.get(i);
            NakedObject nakedObject = HibernateQueryEncoder.getAdapterManager().getAdapterFor(parm.getValue());
            specs[i] = nakedObject.getSpecification();
            objects[i] = nakedObject;
        }
        Data[] objectData = this.getObjectEncoder().encodeActionParameters(specs, objects, new KnownObjects());
        byte[] serialisedQuery = this.serialise(hibernateCriteria.getQuery());
        return new HibernateQueryData(this.downcast(criteria), serialisedQuery, objectData);
    }

    private byte[] serialise(Object toSerialise) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
            objectStream.writeObject(toSerialise);
            objectStream.flush();
            return byteStream.toByteArray();
        }
        catch (Exception e) {
            throw new NakedObjectException((Throwable)e);
        }
    }

    private Object deSerialise(byte[] bytes) {
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
            ObjectInputStream objectStream = new ObjectInputStream(byteStream);
            return objectStream.readObject();
        }
        catch (Exception e) {
            throw new NakedObjectException((Throwable)e);
        }
    }

    protected PersistenceQuery doDecode(NakedObjectSpecification specification, PersistenceQueryData persistenceQueryData) {
        HibernateQueryData queryData = this.downcast(persistenceQueryData);
        QueryPlaceholder query = (QueryPlaceholder)this.deSerialise(queryData.getQueryAsBytes());
        for (int i = 0; i < queryData.getData().length; ++i) {
            Parameter parm = query.getParameters().get(i);
            Data data = queryData.getData()[i];
            NakedObject nakedObject = this.getObjectEncoder().decode(data);
            parm.setValue(nakedObject.getObject());
        }
        return new HibernateQueryCriteria(persistenceQueryData.getPersistenceQueryClass(), query, this.downcast(persistenceQueryData).getResultType());
    }

    private HibernateQueryCriteria downcast(PersistenceQuery criteria) {
        return (HibernateQueryCriteria)criteria;
    }

    private HibernateQueryData downcast(PersistenceQueryData persistenceQueryData) {
        return (HibernateQueryData)persistenceQueryData;
    }

    private static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private static AdapterManager getAdapterManager() {
        return HibernateQueryEncoder.getPersistenceSession().getAdapterManager();
    }
}

