/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.accessor;

import java.lang.reflect.Method;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.PropertyAccessException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.Setter;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.accessor.ConverterFactory;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.accessor.PropertyConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NakedPropertyAccessorAbstract
implements PropertyAccessor {
    protected Method getValueHolderMethod(Class<?> theClass, String propertyName) throws PropertyNotFoundException {
        String naturalName = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        Method getMethod = null;
        try {
            getMethod = theClass.getMethod("get" + naturalName, null);
        }
        catch (SecurityException se) {
            throw new PropertyNotFoundException("Cannot access method get" + naturalName + " in " + theClass + " : " + se.getMessage());
        }
        catch (NoSuchMethodException nsme) {
            try {
                getMethod = theClass.getMethod("get_" + naturalName, null);
            }
            catch (SecurityException se) {
                throw new PropertyNotFoundException("Cannot access method get_" + naturalName + " in " + theClass + " : " + se.getMessage());
            }
            catch (NoSuchMethodException nsme2) {
                throw new PropertyNotFoundException("Unknown property " + naturalName + " in " + theClass);
            }
        }
        return getMethod;
    }

    protected PropertyConverter getConverter(Method getValueHolder) {
        return ConverterFactory.getInstance().getConverter(getValueHolder.getReturnType());
    }

    public Setter getSetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        Method getValueHolder = this.getValueHolderMethod(theClass, propertyName);
        return new NakedSetter(getValueHolder, this.getConverter(getValueHolder), theClass, propertyName);
    }

    public Getter getGetter(Class<?> theClass, String propertyName, boolean isNullable) throws PropertyNotFoundException {
        Method getValueHolder = this.getValueHolderMethod(theClass, propertyName);
        return new NakedGetter(getValueHolder, this.getConverter(getValueHolder), isNullable, theClass, propertyName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NakedGetter
    implements Getter {
        private static final long serialVersionUID = 1L;
        private final Method getValueHolder;
        private final PropertyConverter converter;
        private final boolean isNullable;
        private final Class<?> clazz;
        private final String name;

        NakedGetter(Method getValueHolder, PropertyConverter converter, boolean isNullable, Class<?> clazz, String name) {
            this.getValueHolder = getValueHolder;
            this.converter = converter;
            this.isNullable = isNullable;
            this.clazz = clazz;
            this.name = name;
        }

        public Object get(Object target) throws HibernateException {
            try {
                Object valueHolder = this.getValueHolder.invoke(target, (Object[])null);
                return this.converter.getPersistentValue(valueHolder, this.isNullable);
            }
            catch (Exception e) {
                throw new PropertyAccessException((Throwable)e, "could not get a field value by reflection", false, this.clazz, this.name);
            }
        }

        public Method getMethod() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public Class<?> getReturnType() {
            return this.converter.getPersistentType();
        }

        public Object getForInsert(Object target, Map mergeMap, SessionImplementor session) throws HibernateException {
            return this.get(target);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NakedSetter
    implements Setter {
        private static final long serialVersionUID = 1L;
        private final Method getValueHolder;
        private final PropertyConverter converter;
        private final Class<?> clazz;
        private final String name;

        NakedSetter(Method getValueHolder, PropertyConverter converter, Class<?> clazz, String name) {
            this.getValueHolder = getValueHolder;
            this.converter = converter;
            this.clazz = clazz;
            this.name = name;
        }

        public Method getMethod() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
            try {
                Object valueHolder = this.getValueHolder.invoke(target, (Object[])null);
                this.converter.setValue(valueHolder, value);
            }
            catch (Exception e) {
                throw new PropertyAccessException((Throwable)e, "could not set a field value by reflection", true, this.clazz, this.name);
            }
        }
    }
}

