/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.interceptor;

import java.io.Serializable;
import java.util.Date;
import org.apache.log4j.Logger;
import org.hibernate.CallbackException;
import org.hibernate.EmptyInterceptor;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.Type;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.oidgenerator.HibernateOid;
import org.nakedobjects.plugins.hibernate.objectstore.util.HibernateUtil;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistorUtil;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;

public class NakedInterceptor
extends EmptyInterceptor {
    private static final long serialVersionUID = 1L;
    private static Logger LOG = Logger.getLogger(NakedInterceptor.class);

    public Boolean isTransient(Object entity) {
        NakedObject nakedObject = this.getAdapterManager().getAdapterFor(entity);
        return nakedObject.getOid().isTransient();
    }

    public Object instantiate(String entityName, EntityMode entityMode, Serializable id) throws CallbackException {
        ResolveState nextState;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("instantiate entityName=" + entityName + ", id=" + id + ", mode=" + entityMode));
        }
        HibernateOid oid = HibernateOid.createPersistent(entityName, id);
        NakedObjectSpecification spec = this.getSpecificationLoader().loadSpecification(entityName);
        NakedObject adapter = this.getPersistenceSession().recreateAdapter((Oid)oid, spec);
        ResolveState resolveState = nextState = adapter.getResolveState().isResolved() ? ResolveState.UPDATING : ResolveState.RESOLVING;
        if (!adapter.getResolveState().isResolving()) {
            PersistorUtil.start((NakedObject)adapter, (ResolveState)nextState);
        }
        Object object = adapter.getObject();
        try {
            ClassMetadata classMetadata = HibernateUtil.getSessionFactory().getClassMetadata(entityName);
            classMetadata.setIdentifier(object, id, entityMode);
        }
        catch (HibernateException e) {
            throw new CallbackException("Error getting identifier property for class " + entityName, (Exception)((Object)e));
        }
        return object;
    }

    public Object getEntity(String entityName, Serializable id) throws CallbackException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getEntity entityName=" + entityName + ", id=" + id));
        }
        HibernateOid oid = HibernateOid.createPersistent(entityName, id);
        NakedObject adapter = this.getAdapterManager().getAdapterFor((Oid)oid);
        if (adapter == null || adapter.getResolveState().isGhost() || adapter.getResolveState().isPartlyResolved() || adapter.getResolveState().isResolving()) {
            return null;
        }
        return adapter.getObject();
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        return this.setModified(currentState, propertyNames);
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        return this.setModified(state, propertyNames);
    }

    private boolean setModified(Object[] currentState, String[] propertyNames) {
        boolean updatedModifiedBy = false;
        boolean updatedModifiedOn = false;
        for (int i = 0; i < propertyNames.length; ++i) {
            if (!updatedModifiedBy && propertyNames[i].equals("naked_modified_by")) {
                currentState[i] = this.getSession().getUserName();
                updatedModifiedBy = true;
            }
            if (updatedModifiedOn || !propertyNames[i].equals("naked_modified_on")) continue;
            currentState[i] = new Date();
            updatedModifiedOn = true;
        }
        return updatedModifiedBy || updatedModifiedOn;
    }

    private SpecificationLoader getSpecificationLoader() {
        return NakedObjectsContext.getSpecificationLoader();
    }

    private PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private AdapterManager getAdapterManager() {
        return NakedObjectsContext.getPersistenceSession().getAdapterManager();
    }

    private AuthenticationSession getSession() {
        return NakedObjectsContext.getAuthenticationSession();
    }
}

