package org.nakedobjects.plugins.hibernate.objectstore.metamodel.version;

import java.util.Date;

import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.commons.lang.ToString;


public class LongVersion implements Version {
    private static final long serialVersionUID = 1L;
    private String user;
    private Date time;
    private Long versionNumber;

    public LongVersion() {}

    public LongVersion(final Long versionNumber, final String user, final Date time) {
        this.user = user;
        this.time = time;
        this.versionNumber = versionNumber;
    }

    public boolean different(final Version version) {
        if (version instanceof LongVersion) {
            final LongVersion other = (LongVersion) version;
            return !versionNumber.equals(other.versionNumber);
        } else {
            return false;
        }
    }

    @Override
    public boolean equals(final Object obj) {
        if (obj == this) {
            return true;
        } else if (obj instanceof LongVersion) {
            return !different((LongVersion) obj);
        } else {
            return false;
        }
    }

    public Date getTime() {
        return time;
    }

    public String getUser() {
        return user;
    }

    public Long getVersionNumber() {
        return versionNumber;
    }

    @Override
    public int hashCode() {
        return (int) (versionNumber.longValue() ^ (versionNumber.longValue() >>> 32));
    }

    public void setTime(final Date time) {
        this.time = time;
    }

    public void setUser(final String user) {
        this.user = user;
    }

    public void setVersionNumber(final Long versionNumber) {
        this.versionNumber = versionNumber;
    }

    public String sequence() {
        return Long.toString(serialVersionUID, 16);
    }

    @Override
    public String toString() {
        return "LongVersion#" + versionNumber + " " + ToString.timestamp(time);
    }
}
// Copyright (c) Naked Objects Group Ltd.
