/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.usertype;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.easymock.MockControl;
import org.hibernate.Hibernate;
import org.hibernate.usertype.UserType;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.usertype.DateType;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.usertype.TypesTestCase;

public class DateTypeTest
extends TypesTestCase {
    public void testNullSafeGetNotNull() throws Exception {
        GregorianCalendar cal = new GregorianCalendar(2001, 2, 7);
        cal.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
        java.sql.Date returnedDate = new java.sql.Date(cal.getTimeInMillis());
        MockControl control = MockControl.createControl(ResultSet.class);
        ResultSet rs = (ResultSet)control.getMock();
        control.expectAndReturn((Object)rs.getDate(names[0]), (Object)returnedDate);
        control.expectAndReturn((Object)rs.wasNull(), (Object)false);
        control.replay();
        DateType type = new DateType();
        org.nakedobjects.applib.value.Date returned = (org.nakedobjects.applib.value.Date)type.nullSafeGet(rs, names, null);
        DateTypeTest.assertEquals((String)"day", (int)7, (int)returned.getDay());
        DateTypeTest.assertEquals((String)"month", (int)3, (int)returned.getMonth());
        DateTypeTest.assertEquals((String)"year", (int)2001, (int)returned.getYear());
        control.verify();
    }

    public void testNullSafeGetIsNull() throws Exception {
        MockControl control = MockControl.createControl(ResultSet.class);
        ResultSet rs = (ResultSet)control.getMock();
        control.expectAndReturn((Object)rs.getDate(names[0]), null);
        control.expectAndReturn((Object)rs.wasNull(), (Object)true);
        control.replay();
        DateType type = new DateType();
        DateTypeTest.assertNull((Object)type.nullSafeGet(rs, names, null));
        control.verify();
    }

    public void testNullSafeSetNotNull() throws Exception {
        GregorianCalendar cal = new GregorianCalendar(2001, 2, 7);
        cal.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
        java.sql.Date sqlDate = new java.sql.Date(cal.getTimeInMillis());
        org.nakedobjects.applib.value.Date date = new org.nakedobjects.applib.value.Date((Date)sqlDate);
        MockControl control = MockControl.createControl(PreparedStatement.class);
        PreparedStatement ps = (PreparedStatement)control.getMock();
        ps.setDate(1, sqlDate);
        control.replay();
        DateType type = new DateType();
        type.nullSafeSet(ps, (Object)date, 1);
        control.verify();
    }

    public void testNullSafeSetIsNull() throws Exception {
        MockControl control = MockControl.createControl(PreparedStatement.class);
        PreparedStatement ps = (PreparedStatement)control.getMock();
        ps.setNull(1, Hibernate.DATE.sqlType());
        control.replay();
        DateType type = new DateType();
        type.nullSafeSet(ps, null, 1);
        control.verify();
    }

    public void testBasics() {
        DateType type = new DateType();
        super.basicTest((UserType)type);
        DateTypeTest.assertEquals((String)"returned class", org.nakedobjects.applib.value.Date.class, (Object)type.returnedClass());
    }
}

