/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.persistence.oidgenerator;

import java.io.Serializable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.oidgenerator.HibernateOid;

public class HibernateOidCreate {
    private final Serializable primaryKey = "one";
    private final long id = 2L;

    @Test
    public void createPersistentUsingSerializablePrimaryKeyIsSaved() {
        HibernateOid oid = HibernateOid.createPersistent(HibernateOidCreate.class, (Serializable)this.primaryKey);
        Assert.assertEquals((Object)this.primaryKey, (Object)oid.getPrimaryKey());
    }

    @Test
    public void createTransientUsingSerializablePrimaryKeyIsSaved() {
        HibernateOid oid = HibernateOid.createTransient(HibernateOidCreate.class, (Serializable)this.primaryKey);
        Assert.assertEquals((Object)this.primaryKey, (Object)oid.getPrimaryKey());
    }

    @Test
    public void createPersistentStoresClassName() {
        HibernateOid oid = HibernateOid.createPersistent(HibernateOidCreate.class, (Serializable)this.primaryKey);
        Assert.assertEquals((Object)HibernateOidCreate.class.getName(), (Object)oid.getClassName());
    }

    @Test
    public void createTransientStoresClassName() {
        HibernateOid oid = HibernateOid.createTransient(HibernateOidCreate.class, (Serializable)this.primaryKey);
        Assert.assertEquals((Object)HibernateOidCreate.class.getName(), (Object)oid.getClassName());
    }

    @Test
    public void createPersistentUsesSerializablePrimaryKeyAsTheHibernateId() {
        HibernateOid oid = HibernateOid.createPersistent(HibernateOidCreate.class, (Serializable)this.primaryKey);
        Assert.assertEquals((Object)this.primaryKey, (Object)oid.getHibernateId());
    }

    @Test
    public void createTransientHasANullHibernateId() {
        HibernateOid oid = HibernateOid.createTransient(HibernateOidCreate.class, (Serializable)this.primaryKey);
        Assert.assertNull((Object)oid.getHibernateId());
    }

    @Test
    public void createPersistentHasNoPrevious() {
        HibernateOid oid = HibernateOid.createPersistent(HibernateOidCreate.class, (Serializable)this.primaryKey);
        Assert.assertFalse((boolean)oid.hasPrevious());
    }

    @Test
    public void createTransientHasNoPrevious() {
        HibernateOid oid = HibernateOid.createTransient(HibernateOidCreate.class, (Serializable)this.primaryKey);
        Assert.assertFalse((boolean)oid.hasPrevious());
    }

    @Test
    public void createPersistentIsNotTransient() {
        HibernateOid oid = HibernateOid.createPersistent(HibernateOidCreate.class, (Serializable)this.primaryKey);
        Assert.assertFalse((boolean)oid.isTransient());
    }

    @Test
    public void createTransientIsTransient() {
        HibernateOid oid = HibernateOid.createTransient(HibernateOidCreate.class, (Serializable)this.primaryKey);
        Assert.assertTrue((boolean)oid.isTransient());
    }

    @Test
    public void createPersistentUsingLongIdIsConvertedImplicitlyAndUsedDirectlyAsSerializablePrimaryKey() {
        HibernateOid oid = HibernateOid.createPersistent(HibernateOidCreate.class, (Serializable)Long.valueOf(2L));
        Serializable primaryKey = oid.getPrimaryKey();
        Assert.assertThat((Object)primaryKey, (Matcher)CoreMatchers.is(Long.class));
        Long primaryKeyAsLong = (Long)primaryKey;
        Assert.assertThat((Object)primaryKeyAsLong, (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void createTransientUsingLongIdIsConvertedWithOffsetToLongAndUsedAsSerializablePrimaryKey() {
        HibernateOid oid = HibernateOid.createTransient(HibernateOidCreate.class, (long)2L);
        Serializable primaryKey = oid.getPrimaryKey();
        Assert.assertThat((Object)primaryKey, (Matcher)CoreMatchers.is(Long.class));
        Long primaryKeyAsLong = (Long)primaryKey;
        Assert.assertThat((Object)primaryKeyAsLong, (Matcher)CoreMatchers.is((Object)100002L));
    }
}

