/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.tools.internal;

import java.util.Iterator;
import org.nakedobjects.plugins.hibernate.objectstore.testdomain.BiDirectional;
import org.nakedobjects.plugins.hibernate.objectstore.testdomain.ManyToMany;
import org.nakedobjects.plugins.hibernate.objectstore.testdomain.OneToMany;
import org.nakedobjects.plugins.hibernate.objectstore.testdomain.OneToOne;
import org.nakedobjects.plugins.hibernate.objectstore.testdomain.SimpleObject;
import org.nakedobjects.plugins.hibernate.objectstore.testdomain.SimpleSubClass;
import org.nakedobjects.plugins.hibernate.objectstore.tools.internal.Association;
import org.nakedobjects.plugins.hibernate.objectstore.tools.internal.PersistentNakedClass;
import org.nakedobjects.plugins.hibernate.objectstore.tools.internal.PersistentNakedClasses;
import org.nakedobjects.runtime.testsystem.ProxyJunit3TestCase;

public class PersistentNakedClassesTest
extends ProxyJunit3TestCase {
    public void testNEED_TO_REINSTATE() {
    }

    public void xtestMapClasses() {
        PersistentNakedClasses classes = PersistentNakedClasses.buildPersistentNakedClasses((Boolean)Boolean.TRUE);
        int count = 0;
        Iterator iter = classes.getPersistentClasses();
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        PersistentNakedClassesTest.assertTrue((boolean)classes.isPersistentClass(BiDirectional.class.getName()));
        PersistentNakedClassesTest.assertTrue((boolean)classes.isPersistentClass(ManyToMany.class.getName()));
        PersistentNakedClassesTest.assertTrue((boolean)classes.isPersistentClass(OneToMany.class.getName()));
        PersistentNakedClassesTest.assertTrue((boolean)classes.isPersistentClass(OneToOne.class.getName()));
        PersistentNakedClassesTest.assertEquals((String)"classes count", (int)4, (int)count);
        PersistentNakedClass bidirPc = classes.getPersistentClass(BiDirectional.class.getName());
        PersistentNakedClassesTest.assertTrue((String)"!assn secondOneToMany", (!bidirPc.hasAssociation("secondonetomany") ? 1 : 0) != 0);
        PersistentNakedClassesTest.assertTrue((String)"assn oneToMany", (boolean)bidirPc.hasAssociation("oneToMany"));
        PersistentNakedClassesTest.assertTrue((String)"assn manyToMany", (boolean)bidirPc.hasAssociation("manyToMany"));
        PersistentNakedClassesTest.assertTrue((String)"assn oneToOne", (boolean)bidirPc.hasAssociation("oneToOne"));
        Association assnManyToMany = bidirPc.getAssociation("manyToMany");
        PersistentNakedClassesTest.assertTrue((String)"!many to many inverse", (!assnManyToMany.isInverse() ? 1 : 0) != 0);
        PersistentNakedClassesTest.assertEquals((String)"many to many type", (String)ManyToMany.class.getName(), (String)assnManyToMany.getPersistentClass().getName());
        PersistentNakedClass m2mPc = classes.getPersistentClass(ManyToMany.class.getName());
        PersistentNakedClassesTest.assertTrue((String)"assn many", (boolean)m2mPc.hasAssociation("many"));
        Association assnMany = m2mPc.getAssociation("many");
        PersistentNakedClassesTest.assertTrue((String)"many inverse", (boolean)assnMany.isInverse());
        PersistentNakedClassesTest.assertEquals((String)"many type", (String)BiDirectional.class.getName(), (String)assnMany.getPersistentClass().getName());
    }

    public void xtestMapClassesNotBidirectional() {
        PersistentNakedClasses classes = PersistentNakedClasses.buildPersistentNakedClasses((Boolean)Boolean.FALSE);
        PersistentNakedClass pc = classes.getPersistentClass(BiDirectional.class.getName());
        PersistentNakedClassesTest.assertTrue((String)"!assn secondOneToMany", (!pc.hasAssociation("secondonetomany") ? 1 : 0) != 0);
        PersistentNakedClassesTest.assertTrue((String)"assn oneToMany", (boolean)pc.hasAssociation("oneToMany"));
        PersistentNakedClassesTest.assertTrue((String)"!assn manyToMany", (!pc.hasAssociation("manytomany") ? 1 : 0) != 0);
        PersistentNakedClassesTest.assertTrue((String)"!assn oneToOne", (!pc.hasAssociation("onetoone") ? 1 : 0) != 0);
    }

    public void xtestMapSubClasses() {
        PersistentNakedClasses classes = PersistentNakedClasses.buildPersistentNakedClasses((Boolean)Boolean.TRUE);
        int count = 0;
        Iterator iter = classes.getPersistentClasses();
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        PersistentNakedClassesTest.assertEquals((String)"classes count", (int)2, (int)count);
        PersistentNakedClassesTest.assertTrue((boolean)classes.isPersistentClass(SimpleSubClass.class.getName()));
        PersistentNakedClassesTest.assertTrue((boolean)classes.isPersistentClass(SimpleObject.class.getName()));
        PersistentNakedClass pc = classes.getPersistentClass(SimpleObject.class.getName());
        PersistentNakedClass[] subclasses = pc.getSubClassesArray();
        PersistentNakedClassesTest.assertEquals((String)"subclasses size", (int)1, (int)subclasses.length);
        PersistentNakedClassesTest.assertEquals((String)"subclass name", (String)SimpleSubClass.class.getName(), (String)subclasses[0].getName());
    }
}

