/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.authentication;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.DatabaseMetaData;
import java.util.List;
import org.hibernate.Hibernate;
import org.hibernate.SQLQuery;
import org.hibernate.type.Type;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.plugins.hibernate.objectstore.util.HibernateUtil;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.AuthenticationRequestPassword;
import org.nakedobjects.runtime.authentication.standard.AuthenticatorAbstract;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public class DatabaseAuthenticator
extends AuthenticatorAbstract {
    private static final boolean FAILED_AUTHENTICATION = false;
    private static MessageDigest messageDigest;
    private static String ALGORITHM;
    private static final String NO_ALGORITHM = "none";
    private static String SELECT_USER_SQL;
    private static String SELECT_ROLES_SQL;
    private static final String AUTH_CFG = "nakedobjects.component.authenticator.";
    private static final String SELECT_USER_CFG = "nakedobjects.component.authenticator.selectusersql.";
    private static final String SELECT_ROLES_CFG = "nakedobjects.component.authenticator.selectrolessql.";
    private static final String DEFAULT_CFG = "default";
    private static final String ALGORITHM_CFG = "nakedobjects.component.authenticator.algorithm";
    private static boolean initializedSQL;
    private static boolean initializedAlgorithm;

    private static String getDBType(String dbURL) {
        int indexOfFirstColon;
        int indexOfSecondColon;
        if (dbURL != null && dbURL.toLowerCase().startsWith("jdbc:") && (indexOfSecondColon = dbURL.indexOf(":", (indexOfFirstColon = dbURL.indexOf(":")) + 1)) > indexOfFirstColon) {
            return dbURL.substring(indexOfFirstColon + 1, indexOfSecondColon).trim();
        }
        return DEFAULT_CFG;
    }

    public DatabaseAuthenticator(NakedObjectConfiguration configuration) {
        super(configuration);
    }

    private void justInTimeInitialiseSQL() {
        if (!initializedSQL) {
            try {
                HibernateUtil.startTransaction();
                DatabaseMetaData dbm = HibernateUtil.getCurrentSession().connection().getMetaData();
                HibernateUtil.commitTransaction();
                String databaseType = DatabaseAuthenticator.getDBType(dbm.getURL());
                SELECT_USER_SQL = NakedObjectsContext.getConfiguration().getString("nakedobjects.component.authenticator.selectusersql.default", SELECT_USER_SQL);
                SELECT_ROLES_SQL = this.getConfiguration().getString("nakedobjects.component.authenticator.selectrolessql.default", SELECT_ROLES_SQL);
                SELECT_USER_SQL = NakedObjectsContext.getConfiguration().getString(SELECT_USER_CFG + databaseType, SELECT_USER_SQL);
                SELECT_ROLES_SQL = NakedObjectsContext.getConfiguration().getString(SELECT_ROLES_CFG + databaseType, SELECT_ROLES_SQL);
            }
            catch (Exception e) {
                HibernateUtil.rollbackTransaction();
                throw new NakedObjectException((Throwable)e);
            }
            initializedSQL = true;
        }
    }

    private void justInTimeInitialiseAlgorithm() {
        if (!initializedAlgorithm) {
            try {
                ALGORITHM = this.getConfiguration().getString(ALGORITHM_CFG, ALGORITHM);
                if (!ALGORITHM.equalsIgnoreCase(NO_ALGORITHM)) {
                    messageDigest = MessageDigest.getInstance(ALGORITHM);
                }
            }
            catch (NoSuchAlgorithmException nsa) {
                throw new NakedObjectException((Throwable)nsa);
            }
            initializedAlgorithm = true;
        }
    }

    private final void setRoles(AuthenticationRequest request) {
        try {
            HibernateUtil.startTransaction();
            SQLQuery sq = HibernateUtil.getCurrentSession().createSQLQuery(SELECT_ROLES_SQL);
            sq.setString(0, request.getName());
            sq.addScalar("rr", (Type)Hibernate.STRING);
            List roles = sq.list();
            HibernateUtil.commitTransaction();
            request.setRoles(roles);
        }
        catch (Exception e) {
            HibernateUtil.rollbackTransaction();
            throw new NakedObjectException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateHash(String key) {
        this.justInTimeInitialiseAlgorithm();
        if (ALGORITHM.equalsIgnoreCase(NO_ALGORITHM)) {
            return key;
        }
        MessageDigest messageDigest = DatabaseAuthenticator.messageDigest;
        synchronized (messageDigest) {
            DatabaseAuthenticator.messageDigest.reset();
            DatabaseAuthenticator.messageDigest.update(key.getBytes());
            byte[] bytes = DatabaseAuthenticator.messageDigest.digest();
            StringBuffer buff = new StringBuffer();
            for (int l = 0; l < bytes.length; ++l) {
                String hx = Integer.toHexString(0xFF & bytes[l]);
                if (hx.length() == 1) {
                    buff.append("0");
                }
                buff.append(hx);
            }
            return buff.toString().trim();
        }
    }

    private int count(Object countValue) {
        if (countValue == null) {
            return 0;
        }
        if (countValue instanceof Number) {
            return ((Number)countValue).intValue();
        }
        throw new NakedObjectException("Unexpected type");
    }

    public final boolean isValidUser(AuthenticationRequest request) {
        AuthenticationRequestPassword passwordRequest = (AuthenticationRequestPassword)request;
        String username = passwordRequest.getName();
        if (username == null || username.equals("")) {
            return false;
        }
        String password = passwordRequest.getPassword();
        Assert.assertNotNull((Object)password);
        try {
            HibernateUtil.startTransaction();
            SQLQuery sq = HibernateUtil.getCurrentSession().createSQLQuery(SELECT_USER_SQL);
            sq.setString(0, username);
            sq.setString(1, this.generateHash(password));
            Object result = sq.uniqueResult();
            HibernateUtil.commitTransaction();
            return this.count(result) > 0;
        }
        catch (Exception e) {
            HibernateUtil.rollbackTransaction();
            return false;
        }
    }

    public final boolean isValid(AuthenticationRequest request) {
        this.justInTimeInitialiseSQL();
        boolean valid = this.isValidUser(request);
        if (valid) {
            this.setRoles(request);
        }
        return valid;
    }

    public final boolean canAuthenticate(AuthenticationRequest request) {
        return request instanceof AuthenticationRequestPassword;
    }

    static {
        ALGORITHM = "MD5";
        SELECT_USER_SQL = "select count(*) from user u where username = ? and password = ?";
        SELECT_ROLES_SQL = "select r.rolename as rr from role r, user u, user_role ur where r.id = ur.role and ur.user = u.id and u.username = ?";
    }
}

