/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.query;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.NotYetImplementedException;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.query.DetermineType;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.query.IndexedParameter;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.query.NamedParameter;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.query.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryPlaceholder
implements Query,
Serializable {
    private static final long serialVersionUID = 1L;
    static DetermineType DETERMINE = new DetermineType();
    private transient Session session;
    private transient Query wrappedQuery;
    private final List<Parameter> parameters = new ArrayList<Parameter>();
    private final Map<String, LockMode> lockModes = new HashMap<String, LockMode>();
    private final String queryString;
    private String comment;
    private CacheMode cacheMode;
    private String cacheRegion;
    private Boolean cacheable;
    private Integer firstResult;
    private Integer maxResults;
    private Integer timeout;
    private Integer fetchSize;
    private ResultTransformer resultTransformer;
    private Boolean readOnly;
    private FlushMode flushMode;

    public QueryPlaceholder(String queryString) {
        this.queryString = queryString;
    }

    public int executeUpdate() throws HibernateException {
        return this.getOrCreateRealQuery().executeUpdate();
    }

    public String[] getNamedParameters() throws HibernateException {
        this.notImplemented();
        return null;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String[] getReturnAliases() throws HibernateException {
        this.notImplemented();
        return null;
    }

    public Type[] getReturnTypes() throws HibernateException {
        this.notImplemented();
        return null;
    }

    public Iterator<?> iterate() throws HibernateException {
        return this.getOrCreateRealQuery().iterate();
    }

    public List<?> list() throws HibernateException {
        return this.getOrCreateRealQuery().list();
    }

    public ScrollableResults scroll() throws HibernateException {
        return this.getOrCreateRealQuery().scroll();
    }

    public ScrollableResults scroll(ScrollMode scrollMode) throws HibernateException {
        return this.getOrCreateRealQuery().scroll(scrollMode);
    }

    public Query setBigDecimal(int index, BigDecimal value) {
        return this.setIndexedParameter(index, value, (Type)Hibernate.BIG_DECIMAL);
    }

    public Query setBigDecimal(String name, BigDecimal value) {
        return this.setNamedParameter(name, value, (Type)Hibernate.BIG_DECIMAL);
    }

    public Query setBigInteger(int index, BigInteger value) {
        return this.setIndexedParameter(index, value, (Type)Hibernate.BIG_INTEGER);
    }

    public Query setBigInteger(String name, BigInteger value) {
        return this.setNamedParameter(name, value, (Type)Hibernate.BIG_INTEGER);
    }

    public Query setBinary(int index, byte[] value) {
        return this.setIndexedParameter(index, value, (Type)Hibernate.BINARY);
    }

    public Query setBinary(String name, byte[] value) {
        return this.setNamedParameter(name, value, (Type)Hibernate.BINARY);
    }

    public Query setBoolean(int index, boolean value) {
        return this.setIndexedParameter(index, value, (Type)Hibernate.BOOLEAN);
    }

    public Query setBoolean(String name, boolean value) {
        return this.setNamedParameter(name, value, (Type)Hibernate.BOOLEAN);
    }

    public Query setByte(int index, byte value) {
        return this.setIndexedParameter(index, new Byte(value), (Type)Hibernate.BYTE);
    }

    public Query setByte(String name, byte value) {
        return this.setNamedParameter(name, new Byte(value), (Type)Hibernate.BYTE);
    }

    public Query setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    public Query setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
        return this;
    }

    public Query setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    public Query setCalendar(int index, Calendar value) {
        return this.setIndexedParameter(index, value, (Type)Hibernate.CALENDAR);
    }

    public Query setCalendar(String name, Calendar value) {
        return this.setNamedParameter(name, value, (Type)Hibernate.CALENDAR);
    }

    public Query setCalendarDate(int index, Calendar value) {
        return this.setIndexedParameter(index, value, (Type)Hibernate.CALENDAR_DATE);
    }

    public Query setCalendarDate(String name, Calendar value) {
        return this.setNamedParameter(name, value, (Type)Hibernate.CALENDAR_DATE);
    }

    public Query setCharacter(int index, char value) {
        return this.setIndexedParameter(index, new Character(value), (Type)Hibernate.CHARACTER);
    }

    public Query setCharacter(String name, char value) {
        return this.setNamedParameter(name, new Character(value), (Type)Hibernate.CHARACTER);
    }

    public Query setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public Query setDate(int index, Date value) {
        return this.setIndexedParameter(index, value, (Type)Hibernate.DATE);
    }

    public Query setDate(String name, Date value) {
        return this.setNamedParameter(name, value, (Type)Hibernate.DATE);
    }

    public Query setDouble(int index, double value) {
        return this.setIndexedParameter(index, value, (Type)Hibernate.DOUBLE);
    }

    public Query setDouble(String name, double value) {
        return this.setNamedParameter(name, value, (Type)Hibernate.DOUBLE);
    }

    public Query setEntity(int index, Object value) {
        return this.setIndexedParameter(index, value, Hibernate.OBJECT);
    }

    public Query setEntity(String name, Object value) {
        return this.setNamedParameter(name, value, Hibernate.OBJECT);
    }

    public Query setFetchSize(int value) {
        this.fetchSize = value;
        return this;
    }

    public Query setFirstResult(int value) {
        this.firstResult = value;
        return this;
    }

    public Query setFloat(int index, float value) {
        return this.setIndexedParameter(index, Float.valueOf(value), (Type)Hibernate.FLOAT);
    }

    public Query setFloat(String name, float value) {
        return this.setNamedParameter(name, Float.valueOf(value), (Type)Hibernate.FLOAT);
    }

    public Query setFlushMode(FlushMode value) {
        this.flushMode = value;
        return this;
    }

    public Query setInteger(int index, int value) {
        return this.setIndexedParameter(index, value, (Type)Hibernate.INTEGER);
    }

    public Query setInteger(String name, int value) {
        return this.setNamedParameter(name, value, (Type)Hibernate.INTEGER);
    }

    public Query setLocale(int index, Locale value) {
        return this.setIndexedParameter(index, value, (Type)Hibernate.LOCALE);
    }

    public Query setLocale(String name, Locale value) {
        return this.setNamedParameter(name, value, (Type)Hibernate.LOCALE);
    }

    public Query setLockMode(String key, LockMode value) {
        this.lockModes.put(key, value);
        return this;
    }

    public Query setLong(int index, long value) {
        return this.setIndexedParameter(index, value, (Type)Hibernate.LONG);
    }

    public Query setLong(String name, long value) {
        return this.setNamedParameter(name, value, (Type)Hibernate.LONG);
    }

    public Query setMaxResults(int value) {
        this.maxResults = value;
        return this;
    }

    public Query setParameter(int index, Object value) throws HibernateException {
        return this.setIndexedParameter(index, value, (Type)DETERMINE);
    }

    public Query setParameter(String name, Object value) throws HibernateException {
        return this.setNamedParameter(name, value, (Type)DETERMINE);
    }

    public Query setParameter(int index, Object value, Type type) {
        return this.setIndexedParameter(index, value, type);
    }

    public Query setParameter(String name, Object value, Type type) {
        return this.setNamedParameter(name, value, type);
    }

    public Query setParameterList(String arg0, Collection arg1) throws HibernateException {
        this.notImplemented();
        return null;
    }

    public Query setParameterList(String arg0, Object[] arg1) throws HibernateException {
        this.notImplemented();
        return null;
    }

    public Query setParameterList(String arg0, Collection arg1, Type arg2) throws HibernateException {
        this.notImplemented();
        return null;
    }

    public Query setParameterList(String arg0, Object[] arg1, Type arg2) throws HibernateException {
        this.notImplemented();
        return null;
    }

    public Query setParameters(Object[] values, Type[] types) throws HibernateException {
        Assert.assertTrue((values.length == types.length ? 1 : 0) != 0);
        for (int i = 0; i < values.length; ++i) {
            this.setIndexedParameter(i, values[i], types[i]);
        }
        return this;
    }

    public Query setProperties(Object arg0) throws HibernateException {
        this.notImplemented();
        return null;
    }

    public Query setReadOnly(boolean value) {
        this.readOnly = value;
        return this;
    }

    public Query setResultTransformer(ResultTransformer value) {
        this.resultTransformer = value;
        return this;
    }

    public Query setSerializable(int index, Serializable value) {
        return this.setIndexedParameter(index, value, (Type)Hibernate.SERIALIZABLE);
    }

    public Query setSerializable(String name, Serializable value) {
        return this.setNamedParameter(name, value, (Type)Hibernate.SERIALIZABLE);
    }

    public Query setShort(int index, short value) {
        return this.setIndexedParameter(index, value, (Type)Hibernate.SHORT);
    }

    public Query setShort(String name, short value) {
        return this.setNamedParameter(name, value, (Type)Hibernate.SHORT);
    }

    public Query setString(int index, String value) {
        return this.setIndexedParameter(index, value, (Type)Hibernate.STRING);
    }

    public Query setString(String name, String value) {
        return this.setNamedParameter(name, value, (Type)Hibernate.STRING);
    }

    public Query setText(int index, String value) {
        return this.setIndexedParameter(index, value, (Type)Hibernate.TEXT);
    }

    public Query setText(String name, String value) {
        return this.setNamedParameter(name, value, (Type)Hibernate.TEXT);
    }

    public Query setTime(int index, Date value) {
        return this.setIndexedParameter(index, value, (Type)Hibernate.TIME);
    }

    public Query setTime(String name, Date value) {
        return this.setNamedParameter(name, value, (Type)Hibernate.TIME);
    }

    public Query setTimeout(int value) {
        this.timeout = value;
        return this;
    }

    public Query setTimestamp(int index, Date value) {
        return this.setIndexedParameter(index, value, (Type)Hibernate.TIMESTAMP);
    }

    public Query setTimestamp(String name, Date value) {
        return this.setNamedParameter(name, value, (Type)Hibernate.TIMESTAMP);
    }

    public Object uniqueResult() throws HibernateException {
        return this.getOrCreateRealQuery().uniqueResult();
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Query setProperties(Map arg0) throws HibernateException {
        this.notImplemented();
        return null;
    }

    private Query setIndexedParameter(int index, Object value, Type type) {
        this.parameters.add(new IndexedParameter(index, value, type));
        return this;
    }

    private Query setNamedParameter(String name, Object value, Type type) {
        this.parameters.add(new NamedParameter(name, value, type));
        return this;
    }

    private void setOptions(Query query) {
        if (this.comment != null) {
            query.setComment(this.comment);
        }
        if (this.cacheMode != null) {
            query.setCacheMode(this.cacheMode);
        }
        if (this.cacheRegion != null) {
            query.setCacheRegion(this.cacheRegion);
        }
        if (this.cacheable != null) {
            query.setCacheable(this.cacheable.booleanValue());
        }
        if (this.firstResult != null) {
            query.setFirstResult(this.firstResult.intValue());
        }
        if (this.maxResults != null) {
            query.setMaxResults(this.maxResults.intValue());
        }
        if (this.timeout != null) {
            query.setTimeout(this.timeout.intValue());
        }
        if (this.fetchSize != null) {
            query.setFetchSize(this.fetchSize.intValue());
        }
        if (this.resultTransformer != null) {
            query.setResultTransformer(this.resultTransformer);
        }
        if (this.readOnly != null) {
            query.setReadOnly(this.readOnly.booleanValue());
        }
        if (this.flushMode != null) {
            query.setFlushMode(this.flushMode);
        }
        for (Map.Entry<String, LockMode> entry : this.lockModes.entrySet()) {
            query.setLockMode(entry.getKey(), entry.getValue());
        }
    }

    private Query getOrCreateRealQuery() {
        if (this.wrappedQuery == null) {
            Assert.assertNotNull((Object)this.session);
            this.wrappedQuery = this.session.createQuery(this.queryString);
            this.setOptions(this.wrappedQuery);
            for (Parameter param : this.parameters) {
                param.setParameterInto(this.wrappedQuery);
            }
        }
        return this.wrappedQuery;
    }

    private void notImplemented() {
        throw new NotYetImplementedException("Not Implemented");
    }
}

