/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.persistence.oidgenerator;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.oidgenerator.HibernateOid;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGeneratorAbstract;

public class HibernateOidGenerator
extends OidGeneratorAbstract {
    private static final Logger LOG = Logger.getLogger(HibernateOidGenerator.class);
    private static long transientId = 0L;

    public String name() {
        return "Hibernate Oids";
    }

    public synchronized HibernateOid createTransientOid(Object object) {
        HibernateOid oid = HibernateOid.createTransient(object.getClass(), transientId++);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("created OID " + oid + " for " + new ToString(object)));
        }
        return oid;
    }

    public void convertTransientToPersistentOid(Oid oid) {
        if (!(oid instanceof HibernateOid)) {
            throw new IllegalArgumentException("Oid is not a HibernateOid");
        }
        HibernateOid hibernateOid = (HibernateOid)oid;
        hibernateOid.makePersistent();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("converted transient OID to persistent " + oid));
        }
    }

    public void debugData(DebugString debug) {
    }

    public String debugTitle() {
        return null;
    }
}

