/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore;

import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.hibernate.objectstore.metamodel.criteria.HibernateInstancesCriteria;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.oidgenerator.HibernateOid;
import org.nakedobjects.plugins.hibernate.objectstore.util.HibernateUtil;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.ObjectNotFoundException;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionHydrator;
import org.nakedobjects.runtime.persistence.PersistenceSessionHydratorAware;
import org.nakedobjects.runtime.persistence.PersistorUtil;
import org.nakedobjects.runtime.persistence.UnsupportedFindException;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;
import org.nakedobjects.runtime.persistence.objectstore.ObjectStore;
import org.nakedobjects.runtime.persistence.objectstore.transaction.CreateObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.nakedobjects.runtime.persistence.query.PersistenceQuery;
import org.nakedobjects.runtime.persistence.query.PersistenceQueryFindAllInstances;
import org.nakedobjects.runtime.persistence.query.PersistenceQueryFindByPattern;
import org.nakedobjects.runtime.persistence.query.PersistenceQueryFindByTitle;
import org.nakedobjects.runtime.transaction.NakedObjectTransaction;
import org.nakedobjects.runtime.transaction.ObjectPersistenceException;
import org.nakedobjects.runtime.transaction.PersistenceCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateObjectStore
implements ObjectStore,
PersistenceSessionHydratorAware {
    private static final Logger LOG = Logger.getLogger(HibernateObjectStore.class);
    private static boolean isInitialized = false;
    private PersistenceSessionHydrator hydrator;

    public String name() {
        return "Hibernate Object Store";
    }

    public void open() {
        isInitialized = HibernateUtil.init();
    }

    public void close() {
    }

    public boolean isFixturesInstalled() {
        return isInitialized;
    }

    public void reset() {
        LOG.debug((Object)"resetting object store");
    }

    public void startTransaction() {
        LOG.debug((Object)"Start TX");
    }

    public void abortTransaction() {
        LOG.debug((Object)"Abort TX");
        HibernateUtil.rollbackTransaction();
    }

    public void endTransaction() {
        LOG.debug((Object)"Committing TX");
    }

    protected boolean startHibernateTransaction() {
        Assert.assertFalse((boolean)HibernateUtil.inTransaction());
        HibernateUtil.startTransaction();
        return true;
    }

    protected void commitHibernateTransaction(boolean started) {
        if (started) {
            Assert.assertTrue((boolean)HibernateUtil.inTransaction());
            HibernateUtil.commitTransaction();
        }
    }

    public CreateObjectCommand createCreateObjectCommand(final NakedObject object) {
        LOG.debug((Object)("  create object " + object));
        return new CreateObjectCommand(){

            public void execute(NakedObjectTransaction context) {
                HibernateObjectStore.this.ensureInHibernateTransaction();
                LOG.debug((Object)("  create object - actual save " + object));
                HibernateUtil.getCurrentSession().save(object.getObject());
            }

            public NakedObject onObject() {
                return object;
            }

            public String toString() {
                return "CreateObjectCommand [object=" + object + "]";
            }
        };
    }

    public DestroyObjectCommand createDestroyObjectCommand(final NakedObject object) {
        LOG.debug((Object)("  destroy object " + object));
        return new DestroyObjectCommand(){

            public void execute(NakedObjectTransaction context) {
                HibernateObjectStore.this.ensureInHibernateTransaction();
                LOG.debug((Object)("  destroy object - actual delete " + object));
                HibernateUtil.getCurrentSession().delete(object.getObject());
            }

            public NakedObject onObject() {
                return object;
            }

            public String toString() {
                return "DestroyObjectCommand [object=" + object + "]";
            }
        };
    }

    public SaveObjectCommand createSaveObjectCommand(final NakedObject object) {
        LOG.debug((Object)("  save object " + object));
        return new SaveObjectCommand(){

            public void execute(NakedObjectTransaction context) {
                HibernateObjectStore.this.ensureInHibernateTransaction();
                LOG.debug((Object)("  save object - actual update " + object));
                Object toUpdate = object.getObject();
                HibernateUtil.getCurrentSession().update(toUpdate);
            }

            public NakedObject onObject() {
                return object;
            }

            public String toString() {
                return "SaveObjectCommand [object=" + object + "]";
            }
        };
    }

    public void execute(List<PersistenceCommand> commands) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("execute " + commands.size() + " commands"));
        }
        if (commands.size() <= 0) {
            return;
        }
        try {
            boolean started = this.startHibernateTransaction();
            this.executeCommands(commands);
            this.commitHibernateTransaction(started);
        }
        catch (RuntimeException e) {
            HibernateUtil.rollbackTransaction();
            throw e;
        }
    }

    protected void executeCommands(List<PersistenceCommand> commands) {
        try {
            for (PersistenceCommand command : commands) {
                command.execute(null);
            }
        }
        catch (RuntimeException e) {
            LOG.warn((Object)"Failure during execution", (Throwable)e);
            HibernateUtil.rollbackTransaction();
            throw e;
        }
    }

    public NakedObject getObject(Oid oid, NakedObjectSpecification hint) throws ObjectNotFoundException, ObjectPersistenceException {
        LOG.debug((Object)("getObject id=" + oid));
        Object result = null;
        HibernateOid hoid = (HibernateOid)oid;
        try {
            boolean started = this.startHibernateTransaction();
            result = HibernateUtil.getCurrentSession().get(hoid.getClassName(), hoid.getPrimaryKey());
            this.commitHibernateTransaction(started);
        }
        catch (RuntimeException e) {
            HibernateUtil.rollbackTransaction();
            throw e;
        }
        if (result == null) {
            throw new ObjectNotFoundException(oid);
        }
        return this.hydrator.recreateAdapter((Oid)hoid, result);
    }

    public void resolveImmediately(NakedObject object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("resolveImmediately id=" + object.getOid()));
            LOG.debug((Object)("loadObject id=" + object.getOid()));
        }
        HibernateOid hoid = (HibernateOid)object.getOid();
        try {
            boolean started = this.startHibernateTransaction();
            HibernateUtil.getCurrentSession().load(hoid.getClassName(), hoid.getPrimaryKey());
            this.commitHibernateTransaction(started);
        }
        catch (RuntimeException e) {
            HibernateUtil.rollbackTransaction();
            throw e;
        }
        if (object.getObject() == null) {
            throw new ObjectNotFoundException(object.getOid());
        }
    }

    public void resolveField(NakedObject object, NakedObjectAssociation field) {
        NakedObject collectionAdapter;
        LOG.debug((Object)("resolveField id=" + object.getOid() + ", field=" + field.getId()));
        if (field.isOneToOneAssociation()) {
            NakedObject adapter = field.get(object);
            this.initializeField(object.getObject(), adapter.getObject());
        }
        if (field.isOneToManyAssociation() && !(collectionAdapter = field.get(object)).getResolveState().isResolved()) {
            PersistorUtil.start((NakedObject)collectionAdapter, (ResolveState)ResolveState.RESOLVING);
            Object collection = collectionAdapter.getObject();
            this.initializeField(object.getObject(), collection);
            PersistorUtil.end((NakedObject)collectionAdapter);
        }
    }

    private void initializeField(Object parent, Object field) {
        if (!Hibernate.isInitialized((Object)field)) {
            try {
                boolean started = this.startHibernateTransaction();
                if (field instanceof PersistentCollection) {
                    HibernateUtil.getCurrentSession().lock(parent, LockMode.NONE);
                    Hibernate.initialize((Object)field);
                } else {
                    LazyInitializer lazy = ((HibernateProxy)field).getHibernateLazyInitializer();
                    lazy.setSession((SessionImplementor)HibernateUtil.getCurrentSession());
                    lazy.initialize();
                }
                this.commitHibernateTransaction(started);
                LOG.debug((Object)("initializeField of type " + field.getClass() + " for parent " + parent));
            }
            catch (RuntimeException e) {
                HibernateUtil.rollbackTransaction();
                throw e;
            }
        }
    }

    public NakedObject[] getInstances(PersistenceQuery persistenceQuery) {
        if (persistenceQuery instanceof PersistenceQueryFindByTitle) {
            return this.getInstancesByTitleCriteria((PersistenceQueryFindByTitle)persistenceQuery);
        }
        if (persistenceQuery instanceof PersistenceQueryFindByPattern) {
            return this.getInstancesByPatternCriteria((PersistenceQueryFindByPattern)persistenceQuery);
        }
        if (persistenceQuery instanceof HibernateInstancesCriteria) {
            return this.getInstancesByHibernateCriteria((HibernateInstancesCriteria)persistenceQuery);
        }
        if (persistenceQuery instanceof PersistenceQueryFindAllInstances) {
            return this.getInstances(persistenceQuery.getSpecification());
        }
        throw new UnsupportedFindException("Can't use criteria for search: " + persistenceQuery);
    }

    public boolean hasInstances(NakedObjectSpecification specification) {
        if (!specification.persistability().isPersistable()) {
            LOG.warn((Object)("trying to run hasInstances for non-persistent class " + specification));
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("hasInstances - class=" + specification.getFullName()));
        }
        try {
            boolean started = this.startHibernateTransaction();
            Query query = this.createQuery("select o.id", specification);
            query.setMaxResults(1);
            boolean result = !query.list().isEmpty();
            this.commitHibernateTransaction(started);
            return result;
        }
        catch (RuntimeException e) {
            HibernateUtil.rollbackTransaction();
            throw e;
        }
    }

    public NakedObject[] getInstancesByTitleCriteria(PersistenceQueryFindByTitle criteria) {
        try {
            boolean started = this.startHibernateTransaction();
            String classFullName = criteria.getSpecification().getFullName();
            Criteria hibernateCriteria = HibernateUtil.getCurrentSession().createCriteria(classFullName).add(Restrictions.ilike((String)"title", (String)criteria.getTitle(), (MatchMode)MatchMode.ANYWHERE));
            List results = hibernateCriteria.list();
            NakedObject[] loadedObjects = this.loadObjects(HibernateUtil.getCurrentSession(), criteria.getSpecification(), results);
            this.commitHibernateTransaction(started);
            return loadedObjects;
        }
        catch (RuntimeException e) {
            HibernateUtil.rollbackTransaction();
            throw e;
        }
    }

    public NakedObject[] getInstances(NakedObjectSpecification specification) {
        LOG.debug((Object)("getInstances - class=" + specification.getFullName()));
        try {
            boolean started = this.startHibernateTransaction();
            Query query = this.createQuery(null, specification);
            NakedObject[] objects = this.loadObjects(HibernateUtil.getCurrentSession(), specification, query.list());
            this.commitHibernateTransaction(started);
            return objects;
        }
        catch (RuntimeException e) {
            HibernateUtil.rollbackTransaction();
            throw e;
        }
    }

    public NakedObject[] getInstancesByHibernateCriteria(HibernateInstancesCriteria criteria) {
        try {
            boolean started = this.startHibernateTransaction();
            criteria.setSession(HibernateUtil.getCurrentSession());
            List<?> results = criteria.getResults();
            NakedObject[] objects = this.loadObjects(HibernateUtil.getCurrentSession(), criteria.getSpecification(), results);
            this.commitHibernateTransaction(started);
            return objects;
        }
        catch (RuntimeException e) {
            HibernateUtil.rollbackTransaction();
            throw e;
        }
    }

    public NakedObject[] getInstancesByPatternCriteria(PersistenceQueryFindByPattern criteria) {
        try {
            boolean started = this.startHibernateTransaction();
            Object pojoPattern = criteria.getPattern().getObject();
            Criteria hibernateCriteria = HibernateUtil.getCurrentSession().createCriteria(pojoPattern.getClass()).add((Criterion)Example.create((Object)pojoPattern).excludeProperty("title"));
            List results = hibernateCriteria.list();
            NakedObject[] objects = this.loadObjects(HibernateUtil.getCurrentSession(), criteria.getSpecification(), results);
            this.commitHibernateTransaction(started);
            return objects;
        }
        catch (RuntimeException e) {
            HibernateUtil.rollbackTransaction();
            throw e;
        }
    }

    protected Query createQuery(String select, NakedObjectSpecification specification) {
        this.ensureInHibernateTransaction();
        StringBuffer querySb = new StringBuffer(128);
        if (select != null) {
            querySb.append(select).append(" ");
        }
        querySb.append("from ").append(specification.getFullName()).append(" as o");
        String queryString = querySb.toString();
        LOG.debug((Object)("Query - " + queryString));
        return HibernateUtil.getCurrentSession().createQuery(queryString);
    }

    private NakedObject[] loadObjects(Session session, NakedObjectSpecification specification, List<?> list) {
        NakedObject[] objects = new NakedObject[list.size()];
        int i = 0;
        for (Object object : list) {
            objects[i++] = this.getAdapterManager().getAdapterFor(object);
        }
        return objects;
    }

    private void ensureInHibernateTransaction() {
        Assert.assertTrue((boolean)HibernateUtil.inTransaction());
    }

    public Oid getOidForService(String name) {
        return HibernateOid.createPersistent(name, (Serializable)((Object)name), (Serializable)((Object)name));
    }

    public void registerService(String service, Oid oid) {
    }

    public void debugData(DebugString debug) {
    }

    public String debugTitle() {
        return null;
    }

    public void setHydrator(PersistenceSessionHydrator hydrator) {
        this.hydrator = hydrator;
    }

    private PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private AdapterManager getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }
}

