/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.hibernate.objectstore.util.HibernateUtil;
import org.nakedobjects.runtime.persistence.ObjectNotFoundException;
import org.nakedobjects.runtime.persistence.objectstore.NakedObjectStoreDelegating;
import org.nakedobjects.runtime.persistence.objectstore.ObjectStore;
import org.nakedobjects.runtime.persistence.objectstore.transaction.CreateObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.nakedobjects.runtime.persistence.query.PersistenceQuery;
import org.nakedobjects.runtime.transaction.ObjectPersistenceException;

public class HibernateObjectStoreRemapping
extends NakedObjectStoreDelegating {
    public HibernateObjectStoreRemapping(ObjectStore decorated) {
        super(decorated, "RemappingHibernateObjectStore");
    }

    public CreateObjectCommand createCreateObjectCommand(NakedObject object) {
        this.ensureMapped(object);
        return super.createCreateObjectCommand(object);
    }

    public SaveObjectCommand createSaveObjectCommand(NakedObject object) {
        this.ensureMapped(object);
        return super.createSaveObjectCommand(object);
    }

    public DestroyObjectCommand createDestroyObjectCommand(NakedObject object) {
        this.ensureMapped(object);
        return super.createDestroyObjectCommand(object);
    }

    public NakedObject getObject(Oid oid, NakedObjectSpecification hint) throws ObjectNotFoundException, ObjectPersistenceException {
        this.ensureMapped(hint);
        return super.getObject(oid, hint);
    }

    public void resolveField(NakedObject object, NakedObjectAssociation field) {
        this.ensureMapped(object);
        if (field.isOneToOneAssociation() || field.isOneToManyAssociation()) {
            this.ensureMapped(field.getSpecification());
        }
        super.resolveField(object, field);
    }

    public void resolveImmediately(NakedObject object) {
        this.ensureMapped(object);
        super.resolveImmediately(object);
    }

    public NakedObject[] getInstances(PersistenceQuery criteria) {
        this.ensureMapped(criteria.getSpecification());
        return super.getInstances(criteria);
    }

    public boolean hasInstances(NakedObjectSpecification specification) {
        this.ensureMapped(specification);
        return super.hasInstances(specification);
    }

    private void ensureMapped(NakedObject object) {
        this.ensureMapped(object.getSpecification());
    }

    private void ensureMapped(NakedObjectSpecification specification) {
        HibernateUtil.ensureMapped(specification);
    }
}

