/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.plugins.hibernate.objectstore.HibernateObjectStore;
import org.nakedobjects.plugins.hibernate.objectstore.HibernateObjectStoreImmediate;
import org.nakedobjects.plugins.hibernate.objectstore.HibernateObjectStoreRemapping;
import org.nakedobjects.plugins.hibernate.objectstore.HibernatePersistenceSessionFactory;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.algorithm.SimplePersistAlgorithm;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.algorithm.TwoPassPersistAlgorithm;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.oidgenerator.HibernateOidGenerator;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactoryDelegate;
import org.nakedobjects.runtime.persistence.PersistenceSessionLogger;
import org.nakedobjects.runtime.persistence.adapterfactory.AdapterFactory;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;
import org.nakedobjects.runtime.persistence.objectstore.ObjectStore;
import org.nakedobjects.runtime.persistence.objectstore.ObjectStorePersistenceMechanismInstallerAbstract;
import org.nakedobjects.runtime.persistence.objectstore.algorithm.PersistAlgorithm;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGenerator;
import org.nakedobjects.runtime.system.DeploymentType;

public class HibernatePersistenceMechanismInstaller
extends ObjectStorePersistenceMechanismInstallerAbstract {
    private static final Logger LOG = Logger.getLogger(HibernatePersistenceMechanismInstaller.class);

    public HibernatePersistenceMechanismInstaller() {
        super("hibernate");
    }

    public PersistenceSessionFactory createPersistenceSessionFactory(DeploymentType deploymentType) {
        return new HibernatePersistenceSessionFactory(deploymentType, (PersistenceSessionFactoryDelegate)this);
    }

    public PersistenceSession createPersistenceSession(PersistenceSessionFactory persistenceSessionFactory) {
        LOG.info((Object)("installing " + ((Object)((Object)this)).getClass().getName()));
        return new PersistenceSessionLogger(super.createPersistenceSession(persistenceSessionFactory));
    }

    protected ObjectStore createObjectStore(NakedObjectConfiguration configuration, AdapterFactory nakedObjectFactory, AdapterManager adapterManager) {
        HibernateObjectStore objectStore = this.isSaveImmediate(configuration) ? new HibernateObjectStoreImmediate() : new HibernateObjectStore();
        return this.isRemapping(configuration) ? new HibernateObjectStoreRemapping(objectStore) : objectStore;
    }

    private boolean isSaveImmediate(NakedObjectConfiguration configuration) {
        return configuration.getBoolean("nakedobjects.persistence.hibernate.saveImmediate", true);
    }

    private boolean isRemapping(NakedObjectConfiguration configuration) {
        return configuration.getBoolean("nakedobjects.persistence.hibernate.remapping", false);
    }

    protected OidGenerator createOidGenerator(NakedObjectConfiguration configuration) {
        return new HibernateOidGenerator();
    }

    protected PersistAlgorithm createPersistAlgorithm(NakedObjectConfiguration configuration) {
        String algorithm = this.getPersistAlgorithm(configuration);
        if ("simple".equals(algorithm)) {
            return new SimplePersistAlgorithm();
        }
        return new TwoPassPersistAlgorithm();
    }

    private String getPersistAlgorithm(NakedObjectConfiguration configuration) {
        return configuration.getString("nakedobjects.persistence.hibernate.persistAlgorithm");
    }
}

