/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.metamodel.version;

import java.io.IOException;
import java.util.Date;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputExtended;
import org.nakedobjects.metamodel.commons.encoding.Encodable;
import org.nakedobjects.metamodel.commons.lang.ToString;

public class LongVersion
implements Version,
Encodable {
    private static final long serialVersionUID = 1L;
    private String user;
    private Date time;
    private Long versionNumber;

    public LongVersion() {
        this.time = null;
        this.initialized();
    }

    public LongVersion(Long versionNumber, String user, Date time) {
        this.user = user;
        this.time = time;
        this.versionNumber = versionNumber;
        this.initialized();
    }

    public LongVersion(DataInputExtended input) throws IOException {
        this.user = input.readUTF();
        boolean hasTime = input.readBoolean();
        if (hasTime) {
            this.time = new Date(input.readLong());
        }
        this.versionNumber = input.readLong();
        this.initialized();
    }

    public void encode(DataOutputExtended output) throws IOException {
        output.writeUTF(this.user);
        boolean hasTime = this.time == null;
        output.writeBoolean(hasTime);
        if (hasTime) {
            output.writeLong(this.time.getTime());
        }
        output.writeLong(this.versionNumber.longValue());
    }

    private void initialized() {
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Date getTime() {
        return this.getTime();
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(Long versionNumber) {
        this.versionNumber = versionNumber;
    }

    public boolean different(Version version) {
        if (!(version instanceof LongVersion)) {
            return false;
        }
        LongVersion other = (LongVersion)version;
        return !this.versionNumber.equals(other.versionNumber);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LongVersion) {
            return !this.different((LongVersion)obj);
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.versionNumber ^ this.versionNumber >>> 32);
    }

    public String sequence() {
        return Long.toString(this.versionNumber, 16);
    }

    public String toString() {
        return "LongVersion#" + this.versionNumber + " " + ToString.timestamp((Date)this.getTime());
    }
}

