/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.accessor;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.PropertyAccessException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.Setter;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.oidgenerator.HibernateOid;
import org.nakedobjects.plugins.hibernate.objectstore.util.HibernateUtil;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;

public class OidAccessor
implements PropertyAccessor {
    public Setter getSetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return new OidSetter(theClass, propertyName);
    }

    public Getter getGetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return new OidGetter(theClass, propertyName);
    }

    private static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private static AdapterManager getAdapterManager() {
        return OidAccessor.getPersistenceSession().getAdapterManager();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OidGetter
    implements Getter {
        private static final long serialVersionUID = 1L;
        private final Class<?> clazz;
        private final String name;

        OidGetter(Class<?> clazz, String name) {
            this.clazz = clazz;
            this.name = name;
        }

        public Object get(Object target) throws HibernateException {
            try {
                HibernateOid oid;
                if (HibernateUtil.hasInitRun() && (oid = (HibernateOid)OidAccessor.getAdapterManager().getAdapterFor(target).getOid()) != null) {
                    return oid.getHibernateId();
                }
                return null;
            }
            catch (Exception e) {
                throw new PropertyAccessException((Throwable)e, "could not get a value by reflection", false, this.clazz, this.name);
            }
        }

        public Method getMethod() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public Class<?> getReturnType() {
            return null;
        }

        public Object getForInsert(Object target, Map mergeMap, SessionImplementor session) throws HibernateException {
            return this.get(target);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OidSetter
    implements Setter {
        private static final long serialVersionUID = 1L;
        private final Class<?> clazz;
        private final String name;

        OidSetter(Class<?> clazz, String name) {
            this.clazz = clazz;
            this.name = name;
        }

        public Method getMethod() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
            try {
                NakedObject nakedTarget = OidAccessor.getAdapterManager().getAdapterFor(target);
                if (nakedTarget == null) {
                    throw new HibernateException("could not set a value by reflection, no adapter found- class=" + this.clazz + ", id=" + value);
                }
                HibernateOid hoid = (HibernateOid)nakedTarget.getOid();
                hoid.setHibernateId((Serializable)value);
            }
            catch (Exception e) {
                throw new PropertyAccessException((Throwable)e, "could not set a value by reflection", true, this.clazz, this.name);
            }
        }
    }
}

