/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.accessor;

import java.lang.reflect.Method;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.PropertyAccessException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.Property;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.plugins.hibernate.objectstore.metamodel.version.LongVersion;
import org.nakedobjects.plugins.hibernate.objectstore.util.HibernateUtil;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;

public abstract class OptimisticLockAccessor
implements PropertyAccessor {
    protected abstract LongVersionAccessor getLongVersionAccessor();

    public Setter getSetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        Setter setter = null;
        Property thisProperty = HibernateUtil.getConfiguration().getClassMapping(theClass.getName()).getProperty(propertyName);
        MetaAttribute propertyMeta = thisProperty.getMetaAttribute("naked_property");
        if (propertyMeta != null) {
            PropertyAccessor wrappedAccessor;
            String access = null;
            MetaAttribute accessMeta = thisProperty.getMetaAttribute("naked_access");
            if (accessMeta != null) {
                access = accessMeta.getValue();
            }
            if ((wrappedAccessor = PropertyAccessorFactory.getPropertyAccessor(access)) != null) {
                setter = wrappedAccessor.getSetter(theClass, propertyMeta.getValue());
            }
        }
        return new OptimisticLockSetter(theClass, propertyName, this.getLongVersionAccessor(), setter);
    }

    public Getter getGetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        Property thisProperty = HibernateUtil.getConfiguration().getClassMapping(theClass.getName()).getProperty(propertyName);
        MetaAttribute propertyMeta = thisProperty.getMetaAttribute("naked_property");
        if (propertyMeta != null) {
            PropertyAccessor wrappedAccessor;
            String access = null;
            MetaAttribute accessMeta = thisProperty.getMetaAttribute("naked_access");
            if (accessMeta != null) {
                access = accessMeta.getValue();
            }
            if ((wrappedAccessor = PropertyAccessorFactory.getPropertyAccessor(access)) != null) {
                return wrappedAccessor.getGetter(theClass, propertyMeta.getValue());
            }
        }
        return new OptimisticLockGetter(theClass, propertyName, this.getLongVersionAccessor());
    }

    private static AdapterManager getAdapterManager() {
        return OptimisticLockAccessor.getPersistenceSession().getAdapterManager();
    }

    private static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OptimisticLockGetter
    implements Getter {
        private static final long serialVersionUID = 1L;
        private final Class<?> clazz;
        private final String name;
        private final LongVersionAccessor versionAccessor;

        OptimisticLockGetter(Class<?> clazz, String name, LongVersionAccessor versionAccessor) {
            this.clazz = clazz;
            this.name = name;
            this.versionAccessor = versionAccessor;
        }

        public Object get(Object target) throws HibernateException {
            try {
                NakedObject nakedTarget = OptimisticLockAccessor.getAdapterManager().getAdapterFor(target);
                if (nakedTarget == null) {
                    return null;
                }
                LongVersion version = (LongVersion)nakedTarget.getVersion();
                if (version == null) {
                    return null;
                }
                return this.versionAccessor.get(version);
            }
            catch (Exception e) {
                throw new PropertyAccessException((Throwable)e, "could not get a value by reflection", false, this.clazz, this.name);
            }
        }

        public Method getMethod() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public Class<?> getReturnType() {
            return this.versionAccessor.getReturnType();
        }

        public Object getForInsert(Object target, Map mergeMap, SessionImplementor session) throws HibernateException {
            return this.get(target);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OptimisticLockSetter
    implements Setter {
        private static final long serialVersionUID = 1L;
        private final Class<?> clazz;
        private final String name;
        private final LongVersionAccessor versionAccessor;
        private final Setter wrappedSetter;

        OptimisticLockSetter(Class<?> clazz, String name, LongVersionAccessor versionAccessor, Setter wrappedSetter) {
            this.clazz = clazz;
            this.name = name;
            this.versionAccessor = versionAccessor;
            this.wrappedSetter = wrappedSetter;
        }

        public Method getMethod() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
            try {
                NakedObject nakedTarget = OptimisticLockAccessor.getAdapterManager().getAdapterFor(target);
                LongVersion version = (LongVersion)nakedTarget.getVersion();
                if (version == null) {
                    version = new LongVersion();
                    nakedTarget.setOptimisticLock((Version)version);
                }
                this.versionAccessor.set(version, value);
                if (this.wrappedSetter != null) {
                    this.wrappedSetter.set(target, value, factory);
                }
            }
            catch (Exception e) {
                throw new PropertyAccessException((Throwable)e, "could not set a value by reflection", true, this.clazz, this.name);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface LongVersionAccessor {
        public Object get(LongVersion var1);

        public void set(LongVersion var1, Object var2);

        public Class<?> getReturnType();
    }
}

