/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.persistence.oidgenerator;

import java.io.IOException;
import java.io.Serializable;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputExtended;
import org.nakedobjects.metamodel.commons.ensure.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HibernateOid
implements Oid {
    static final int STANDARD_OFFSET = 100000;
    private static final long serialVersionUID = 1L;
    private String className;
    private Serializable primaryKey;
    private Serializable hibernateId;
    private boolean isTransient;
    private HibernateOid previous;
    private int cachedHashCode;
    private String cachedToString;

    public static HibernateOid createTransient(Class<?> clazz, long id) {
        return HibernateOid.createTransient(clazz.getName(), id);
    }

    public static HibernateOid createTransient(String className, long id) {
        return HibernateOid.createTransient(className, (Serializable)new Long(id + 100000L));
    }

    public static HibernateOid createTransient(Class<?> clazz, Serializable primaryKey) {
        return HibernateOid.createTransient(clazz.getName(), primaryKey);
    }

    public static HibernateOid createTransient(String className, Serializable primaryKey) {
        return new HibernateOid(className, primaryKey, null, State.TRANSIENT);
    }

    public static HibernateOid createPersistent(Class<?> clazz, Serializable primaryKey) {
        return HibernateOid.createPersistent(clazz.getName(), primaryKey);
    }

    public static HibernateOid createPersistent(String className, Serializable primaryKey) {
        return HibernateOid.createPersistent(className, primaryKey, primaryKey);
    }

    public static HibernateOid createPersistent(String className, Serializable primaryKey, Serializable hibernateId) {
        return new HibernateOid(className, primaryKey, hibernateId, State.PERSISTENT);
    }

    private HibernateOid(String className, Serializable primaryKey, Serializable hibernateId, State state) {
        this.className = className;
        this.primaryKey = primaryKey;
        this.hibernateId = hibernateId;
        this.isTransient = state.isTransient();
        this.initialized();
    }

    public HibernateOid(DataInputExtended input) throws IOException {
        this.className = input.readUTF();
        this.primaryKey = (Serializable)input.readSerializable(Serializable.class);
        this.isTransient = input.readBoolean();
        this.hibernateId = (Serializable)input.readSerializable(Serializable.class);
        this.previous = (HibernateOid)input.readSerializable(HibernateOid.class);
        this.initialized();
    }

    public void encode(DataOutputExtended output) throws IOException {
        output.writeUTF(this.className);
        output.writeSerializable((Object)this.primaryKey);
        output.writeBoolean(this.isTransient);
        output.writeSerializable((Object)this.hibernateId);
        output.writeEncodable((Object)this.previous);
    }

    private void initialized() {
        this.cacheState();
    }

    public void copyFrom(Oid oid) {
        Assert.assertTrue((boolean)(oid instanceof HibernateOid));
        HibernateOid from = (HibernateOid)oid;
        this.primaryKey = from.primaryKey;
        this.className = from.className;
        this.hibernateId = from.hibernateId;
        this.isTransient = from.isTransient;
        this.cacheState();
    }

    public String getClassName() {
        return this.className;
    }

    public Serializable getPrimaryKey() {
        return this.primaryKey;
    }

    public void makePersistent() {
        Assert.assertTrue((boolean)this.isTransient());
        this.previous = new HibernateOid(this.className, this.primaryKey, null, State.TRANSIENT);
        this.primaryKey = this.hibernateId;
        this.isTransient = false;
        this.cacheState();
    }

    public Serializable getHibernateId() {
        return this.hibernateId;
    }

    public void setHibernateId(Serializable hibernateId) {
        this.hibernateId = hibernateId;
        this.cacheState();
    }

    public Oid getPrevious() {
        return this.previous;
    }

    public boolean hasPrevious() {
        return this.previous != null;
    }

    public void clearPrevious() {
        this.previous = null;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof HibernateOid) {
            HibernateOid o = (HibernateOid)obj;
            return this.className.equals(o.className) && this.primaryKey.equals(o.primaryKey);
        }
        return false;
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    private void cacheState() {
        this.cachedHashCode = 17;
        this.cachedHashCode = 37 * this.cachedHashCode + this.className.hashCode();
        this.cachedHashCode = 37 * this.cachedHashCode + this.primaryKey.hashCode();
        this.cachedToString = (this.isTransient() ? "T" : "") + "HOID#" + this.primaryKey.toString() + "/" + this.className + (this.hibernateId == null ? "" : "(" + this.hibernateId + ")") + (this.previous == null ? "" : "+");
    }

    public String toString() {
        return this.cachedToString;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        TRANSIENT,
        PERSISTENT;


        public boolean isTransient() {
            return this == TRANSIENT;
        }

        public boolean isPersistent() {
            return this == PERSISTENT;
        }
    }
}

