/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.tools.internal;

import java.beans.Introspector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.DOMWriter;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Mappings;
import org.hibernate.type.CompositeCustomType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.nakedobjects.applib.value.Date;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.exceptions.UnknownTypeException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.NakedObjectSpecificationException;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.accessor.ConverterFactory;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.accessor.NakedPropertyAccessor;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.accessor.OidAccessor;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.accessor.PropertyConverter;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.accessor.TimestampAccessor;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.accessor.TitleAccessor;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.accessor.UserAccessor;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.accessor.VersionAccessor;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.usertype.DateType;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.usertype.DomainModelResourceType;
import org.nakedobjects.plugins.hibernate.objectstore.tools.internal.Association;
import org.nakedobjects.plugins.hibernate.objectstore.tools.internal.MappingHelper;
import org.nakedobjects.plugins.hibernate.objectstore.tools.internal.PersistentNakedClass;
import org.nakedobjects.plugins.hibernate.objectstore.tools.internal.PersistentNakedClasses;
import org.nakedobjects.plugins.hibernate.objectstore.util.HibernateUtil;
import org.nakedobjects.runtime.context.NakedObjectsContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Nof2HbmXml {
    private static final String PRIMARY_KEY_PREFIX = "PK";
    private static final String PRIMARY_KEY_SUFFIX = "ID";
    private static final String FOREIGN_KEY_PREFIX = "FK";
    private static final String COLUMN_PROPERTY_PREFIX = "nakedobjects.persistence.hibernate.column.";
    private static final String RESERVED_COL_SUFFIX = "nakedobjects.persistence.hibernate.reservedColumnNameSuffix";
    private static final String RESERVED_TAB_SUFFIX = "nakedobjects.persistence.hibernate.reservedTableNameSuffix";
    private static final String ID_TYPE = "long";
    private static final String FILE_SEPERATOR = System.getProperty("file.separator");
    private static final Logger LOG = Logger.getLogger(Nof2HbmXml.class);
    private final ConverterFactory converterFactory = ConverterFactory.getInstance();
    private final PersistentNakedClasses persistentClasses;
    private static final int colType = 0;
    private static final int tabType = 1;
    private static String[] reservedNameSuffixes = new String[]{"_column", "_TABLE"};
    private final String listType;
    private final String collections;
    private final boolean defaultAssociationFieldAccess;
    private final boolean defaultValueFieldAccess;
    private final String versionProperty;
    private final String modifiedByProperty;
    private final String modifiedOnProperty;
    private final String versionAccess;
    private final String modifiedByAccess;
    private final String modifiedOnAccess;
    private final String exportDirectory;
    private final String fieldPrefix;
    private final NakedObjectConfiguration columnNames;
    private final String applibPrefix;
    private final String applibReplacementPrefix;
    private final boolean lazyLoadObjects = true;
    private final boolean lazyLoadCollections = false;

    public Nof2HbmXml() {
        NakedObjectConfiguration config = NakedObjectsContext.getConfiguration();
        this.listType = config.getString("nakedobjects.persistence.hibernate.list", "bag");
        this.collections = config.getString("nakedobjects.persistence.hibernate.collections", "many");
        this.defaultAssociationFieldAccess = config.getBoolean("nakedobjects.persistence.hibernate.associationFieldAccess", false);
        this.defaultValueFieldAccess = config.getBoolean("nakedobjects.persistence.hibernate.valueFieldAccess", false);
        this.versionProperty = config.getString("nakedobjects.persistence.hibernate.version");
        this.modifiedByProperty = config.getString("nakedobjects.persistence.hibernate.modified_by");
        this.modifiedOnProperty = config.getString("nakedobjects.persistence.hibernate.modified_on");
        this.versionAccess = config.getString("nakedobjects.persistence.hibernate.version.access");
        this.modifiedByAccess = config.getString("nakedobjects.persistence.hibernate.modified_by.access");
        this.modifiedOnAccess = config.getString("nakedobjects.persistence.hibernate.modified_on.access");
        this.fieldPrefix = config.getString("nakedobjects.persistence.hibernate.fieldPrefix", "");
        this.columnNames = config.getProperties(COLUMN_PROPERTY_PREFIX);
        Nof2HbmXml.reservedNameSuffixes[0] = config.getString(RESERVED_COL_SUFFIX, reservedNameSuffixes[0]);
        Nof2HbmXml.reservedNameSuffixes[1] = config.getString(RESERVED_TAB_SUFFIX, reservedNameSuffixes[1]);
        this.exportDirectory = config.getString("nakedobjects.persistence.hibernate.hbm-export", new File(".").getAbsolutePath() + FILE_SEPERATOR + "mappings");
        MappingHelper.loadRequiredClasses();
        this.persistentClasses = PersistentNakedClasses.buildPersistentNakedClasses(null);
        String name = Date.class.getName();
        int pos = name.lastIndexOf(46) + 1;
        this.applibPrefix = name.substring(0, pos);
        name = DateType.class.getName();
        pos = name.lastIndexOf(46) + 1;
        this.applibReplacementPrefix = name.substring(0, pos);
        LOG.debug((Object)("mapping tree:" + this.persistentClasses.debugString()));
    }

    private String capitalizedPropertyName(String propertyName) {
        return propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }

    private String javaBeanGetterName(String propertyName) {
        return "get" + this.capitalizedPropertyName(propertyName);
    }

    private String dotNetBeanGetterName(String propertyName) {
        return "get_" + this.capitalizedPropertyName(propertyName);
    }

    private void writeMappingDoc(Document doc, String className) {
        String file;
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        File basedirFile = new File(this.exportDirectory);
        String dir = "";
        int pos = className.lastIndexOf(".");
        if (pos < 0) {
            file = className;
        } else {
            file = className.substring(pos + 1);
            dir = className.substring(0, pos).replace(".", FILE_SEPERATOR);
        }
        file = file + ".hbm.xml";
        File outputDir = new File(basedirFile, dir);
        outputDir.mkdirs();
        File outFile = new File(outputDir, file);
        LOG.info((Object)("writing " + outFile.getAbsolutePath()));
        this.serializeToXML(doc, outFile, outformat);
        LOG.info((Object)("Writing mapping file: " + outFile.getAbsolutePath()));
    }

    public void configure(Configuration cfg) {
        Mappings mappings = cfg.createMappings();
        Iterator<PersistentNakedClass> iter = this.persistentClasses.getPersistentClasses();
        while (iter.hasNext()) {
            PersistentNakedClass persistentClass = iter.next();
            String className = persistentClass.getName();
            if (mappings.getClass(className) == null) {
                LOG.debug((Object)("binding persistent class " + className));
                Document doc4j = this.createDocument(persistentClass);
                org.w3c.dom.Document docW3c = this.createW3cDoc(doc4j);
                cfg.addDocument(docW3c);
                this.writeMappingDoc(doc4j, className);
                continue;
            }
            LOG.info((Object)("class [" + className + "] is already mapped, skipping.. "));
        }
    }

    public void createMappingFiles() {
        Iterator<PersistentNakedClass> iter = this.persistentClasses.getPersistentClasses();
        while (iter.hasNext()) {
            PersistentNakedClass persistentClass = iter.next();
            String className = persistentClass.getName();
            LOG.debug((Object)("create mapping for persistent class " + className));
            Document doc4j = this.createDocument(persistentClass);
            this.writeMappingDoc(doc4j, className);
        }
    }

    protected org.w3c.dom.Document createW3cDoc(Document doc4j) {
        DOMWriter writer = new DOMWriter();
        try {
            return writer.write(doc4j);
        }
        catch (DocumentException e) {
            throw new NakedObjectException((Throwable)e);
        }
    }

    private Element addColumnAttribute(Element element, String name) {
        return element.addAttribute("column", this.deconflictColumnName(name));
    }

    private Element addTableAttribute(Element element, String name) {
        return element.addAttribute("table", this.deconflictTableName(name));
    }

    private void bindTitle(Element classElement, PersistentNakedClass persistentNakedClass, boolean valueFieldAccess) {
        Element title = this.addColumnAttribute(classElement.addElement("property").addAttribute("name", "title"), "title");
        this.addTitleType(persistentNakedClass.getSpecification(), title, "type", true, valueFieldAccess);
    }

    private String deconflictName(String name, int type) {
        String validName = name;
        while (HibernateUtil.isDatabaseKeyword(validName)) {
            validName = validName + reservedNameSuffixes[type];
        }
        if (!name.equals(validName)) {
            LOG.warn((Object)("name: " + name + " is a database keyword, replacing with: " + validName));
        }
        return validName;
    }

    private String deconflictTableName(String name) {
        return this.deconflictName(name, 1);
    }

    private String deconflictColumnName(String name) {
        return this.deconflictName(name, 0);
    }

    protected Document createDocument(PersistentNakedClass persistentNakedClass) {
        Element classElement;
        LOG.info((Object)("creating hbm.xml for class " + persistentNakedClass.getName()));
        Document document = DocumentHelper.createDocument();
        document.addDocType("hibernate-mapping", "-//Hibernate/Hibernate Mapping DTD 3.0//EN", "http://hibernate.sourceforge.net/hibernate-mapping-3.0.dtd");
        Element root = document.addElement("hibernate-mapping");
        if (persistentNakedClass.isDuplicateUnqualifiedClassName()) {
            root.addAttribute("auto-import", "false");
        }
        boolean associationFieldAccess = this.defaultAssociationFieldAccess;
        boolean valueFieldAccess = this.defaultValueFieldAccess;
        if (persistentNakedClass.getParent().isRoot()) {
            classElement = this.bindRootClass(persistentNakedClass, root, valueFieldAccess);
            this.bindVersion(classElement, valueFieldAccess);
            this.bindTitle(classElement, persistentNakedClass, valueFieldAccess);
        } else {
            classElement = this.bindSubClass(persistentNakedClass, root);
        }
        if (persistentNakedClass.isAbstract()) {
            classElement.addAttribute("abstract", "true");
        }
        String versionId = this.versionProperty == null ? null : this.versionProperty.toLowerCase();
        String modifiedById = this.modifiedByProperty == null ? null : this.modifiedByProperty.toLowerCase();
        String modifiedOnId = this.modifiedOnProperty == null ? null : this.modifiedOnProperty.toLowerCase();
        NakedObjectAssociation[] allFields = persistentNakedClass.getUniqueFields();
        for (int i = 0; i < allFields.length; ++i) {
            NakedObjectAssociation field = allFields[i];
            if (!field.isNotDerived()) continue;
            if (field.isOneToManyAssociation()) {
                this.bindCollection(classElement, persistentNakedClass, field, associationFieldAccess);
                continue;
            }
            if (field.isOneToOneAssociation()) {
                Element assnElement;
                if (field.getSpecification().isValueOrIsAggregated()) {
                    String fieldId = field.getId();
                    if (fieldId.equals("id") && field.getId().equals("id") || fieldId.equals(versionId) || fieldId.equals(modifiedById) || fieldId.equals(modifiedOnId) || fieldId.equals("title")) continue;
                    this.bindProperty(field, classElement, valueFieldAccess);
                    continue;
                }
                LOG.debug((Object)("Binding persistent association [" + field.getId() + "]"));
                if (this.persistentClasses.isPersistentClass(field.getSpecification().getFullName())) {
                    assnElement = this.bindAssociation(classElement, persistentNakedClass, field, associationFieldAccess);
                } else if (this.persistentClasses.isPersistentInterface(field.getSpecification().getFullName()) || field.getSpecification().getFullName().equals("java.lang.Object")) {
                    this.warnAnyAssociation(persistentNakedClass, field);
                    assnElement = classElement.addElement("any").addAttribute("name", this.getPropertyName(field, associationFieldAccess));
                    this.bindAnyAssociation(assnElement, field);
                } else {
                    throw new NakedObjectException("Un-mapped class/interface: " + field.getSpecification().getFullName());
                }
                if (!associationFieldAccess) continue;
                assnElement.addAttribute("access", "field");
                continue;
            }
            throw new UnknownTypeException((Object)field);
        }
        return document;
    }

    private void warnAnyAssociation(PersistentNakedClass persistentNakedClass, NakedObjectAssociation field) {
        LOG.info((Object)("Binding persistent association as an ANY association! [class=" + persistentNakedClass.getName() + ", field=" + field.getId() + "]"));
    }

    private void bindProperty(NakedObjectAssociation field, Element classElement, boolean valueFieldAccess) {
        LOG.debug((Object)("Binding persistent property [" + field.getId() + "]"));
        Element property = classElement.addElement("property");
        this.setType(field, property, "type", true, valueFieldAccess);
        Attribute access = property.attribute("access");
        boolean fieldAccess = access != null && access.getStringValue().equals("field");
        property.addAttribute("name", this.getPropertyName(field, fieldAccess));
        Type type = TypeFactory.heuristicType((String)property.attribute("type").getValue(), null);
        if (type instanceof CompositeCustomType) {
            String[] names = ((CompositeCustomType)type).getPropertyNames();
            for (int i = 0; i < names.length; ++i) {
                String compositeColumnName = this.deconflictColumnName(this.columnName(field.getId()) + "_" + names[i]);
                property.addElement("column").addAttribute("name", compositeColumnName);
            }
        } else {
            this.addColumnAttribute(property, this.columnName(field.getId()));
        }
    }

    private String columnName(String column) {
        return this.columnNames.getString(COLUMN_PROPERTY_PREFIX + column, column);
    }

    private Element bindRootClass(PersistentNakedClass persistentNakedClass, Element root, boolean valueFieldAccess) {
        String tableName = this.deconflictTableName(persistentNakedClass.getTableName());
        Element classElement = root.addElement("class").addAttribute("name", persistentNakedClass.getName()).addAttribute("table", tableName).addAttribute("lazy", "true");
        Element id = this.addColumnAttribute(classElement.addElement("id").addAttribute("name", "id"), PRIMARY_KEY_PREFIX + tableName.toLowerCase() + PRIMARY_KEY_SUFFIX);
        this.addIdType(persistentNakedClass.getSpecification(), id, "type", true, valueFieldAccess);
        id.addElement("generator").addAttribute("class", "native");
        if (persistentNakedClass.hasSubClasses()) {
            classElement.addElement("discriminator").addAttribute("column", "discriminator").addAttribute("type", "string");
            if (!persistentNakedClass.isAbstract()) {
                classElement.addAttribute("discriminator-value", persistentNakedClass.getName());
            }
        }
        return classElement;
    }

    private Element bindSubClass(PersistentNakedClass persistentNakedClass, Element root) {
        Element classElement = root.addElement("subclass").addAttribute("name", persistentNakedClass.getName()).addAttribute("extends", persistentNakedClass.getParent().getName());
        if (!persistentNakedClass.isAbstract()) {
            classElement.addAttribute("discriminator-value", persistentNakedClass.getName());
        }
        return classElement;
    }

    private void addIdType(NakedObjectSpecification spec, Element id, String attributeName, boolean nakedPropertyAccessor, boolean valueFieldAccess) {
        try {
            NakedObjectAssociation idField = spec.getAssociation("id");
            if (idField != null && idField.getId().equals("id")) {
                this.setType(idField, id, attributeName, nakedPropertyAccessor, valueFieldAccess);
                return;
            }
        }
        catch (NakedObjectSpecificationException ignore) {
            // empty catch block
        }
        Method getIdMethod = this.extractGetMethod(spec, "id");
        if (getIdMethod != null) {
            id.addAttribute(attributeName, getIdMethod.getReturnType().getName());
        } else {
            id.addAttribute(attributeName, ID_TYPE);
            if (nakedPropertyAccessor) {
                id.addAttribute("access", OidAccessor.class.getName());
            }
        }
    }

    private void addTitleType(NakedObjectSpecification spec, Element element, String attributeName, boolean nakedPropertyAccessor, boolean valueFieldAccess) {
        try {
            NakedObjectAssociation titleField = spec.getAssociation("title");
            if (titleField != null && titleField.getId().equals("Title")) {
                this.setType(titleField, element, attributeName, nakedPropertyAccessor, valueFieldAccess);
                return;
            }
        }
        catch (NakedObjectSpecificationException ignore) {
            // empty catch block
        }
        Method getTitleMethod = this.extractGetMethod(spec, "Title");
        if (getTitleMethod != null) {
            element.addAttribute(attributeName, getTitleMethod.getReturnType().getName());
        } else {
            element.addAttribute(attributeName, "string");
            if (nakedPropertyAccessor) {
                element.addAttribute("access", TitleAccessor.class.getName());
            }
        }
    }

    private String getPropertyName(NakedObjectAssociation field, boolean fieldAccess) {
        String name = field.getId().replace(" ", "");
        if (fieldAccess) {
            name = this.fieldPrefix + name;
        }
        return Introspector.decapitalize(name);
    }

    private Element bindAssociation(Element classElement, PersistentNakedClass persistentNakedClass, NakedObjectAssociation field, boolean associationFieldAccess) {
        Association assn = persistentNakedClass.getAssociation(field.getId());
        if (assn != null && assn.getField().isOneToOneAssociation()) {
            if (assn.isInverse()) {
                String FKColumn = this.deconflictColumnName(FOREIGN_KEY_PREFIX + field.getId());
                return classElement.addElement("many-to-one").addAttribute("name", this.getPropertyName(field, associationFieldAccess)).addAttribute("column", FKColumn).addAttribute("class", field.getSpecification().getFullName()).addAttribute("unique", "true");
            }
            return classElement.addElement("one-to-one").addAttribute("name", this.getPropertyName(field, associationFieldAccess)).addAttribute("class", field.getSpecification().getFullName()).addAttribute("property-ref", this.getPropertyName(assn.getField(), associationFieldAccess));
        }
        String FKColumn = this.deconflictColumnName(FOREIGN_KEY_PREFIX + field.getId());
        return classElement.addElement("many-to-one").addAttribute("name", this.getPropertyName(field, associationFieldAccess)).addAttribute("column", FKColumn).addAttribute("class", field.getSpecification().getFullName());
    }

    private void bindAnyAssociation(Element anyElement, NakedObjectAssociation field) {
        this.addIdType(field.getSpecification(), anyElement, "id-type", false, false);
        anyElement.addElement("column").addAttribute("name", this.deconflictColumnName(field.getId() + "type"));
        anyElement.addElement("column").addAttribute("name", this.deconflictColumnName(field.getId() + PRIMARY_KEY_SUFFIX));
    }

    private Element bindCollection(Element classElement, PersistentNakedClass persistentNakedClass, NakedObjectAssociation field, boolean associationFieldAccess) {
        LOG.debug((Object)("Binding persistent collection [" + field.getId() + "]"));
        NakedObjectSpecification spec = persistentNakedClass.getSpecification();
        Class<?> returnType = this.getReturnType(field, spec);
        String collectionType = this.getCollectionType(returnType);
        Element collElement = classElement.addElement(collectionType);
        boolean fieldAccess = associationFieldAccess;
        collElement.addAttribute("access", "field");
        collElement.addAttribute("name", this.getPropertyName(field, fieldAccess));
        Element keyElement = collElement.addElement("key");
        String tableName = this.deconflictTableName(persistentNakedClass.getTableName());
        String associationType = null;
        if (field.getSpecification().isService()) {
            this.addColumnAttribute(keyElement, FOREIGN_KEY_PREFIX + tableName.toLowerCase());
            associationType = "element";
            this.addTableAttribute(collElement, tableName + "_" + field.getId().toUpperCase());
        } else {
            Association assn = persistentNakedClass.getAssociation(field.getId());
            if (assn != null) {
                NakedObjectAssociation associatedField = assn.getField();
                if (associatedField.isOneToOneAssociation()) {
                    associationType = "one-to-many";
                    collElement.addAttribute("inverse", "true");
                    this.addColumnAttribute(keyElement, FOREIGN_KEY_PREFIX + associatedField.getId());
                } else {
                    associationType = "many-to-many";
                    this.addColumnAttribute(keyElement, FOREIGN_KEY_PREFIX + tableName.toLowerCase());
                    PersistentNakedClass associatedClass = assn.getPersistentClass();
                    String associatedTableName = this.deconflictTableName(associatedClass.getTableName());
                    if (assn.isInverse()) {
                        this.addTableAttribute(collElement, associatedTableName + "_" + tableName);
                        collElement.addAttribute("inverse", "true");
                    } else {
                        this.addTableAttribute(collElement, tableName + "_" + associatedTableName);
                    }
                }
            } else if (this.persistentClasses.isPersistentClass(field.getSpecification().getFullName())) {
                associationType = this.collections + "-to-many";
                if ("many".equals(this.collections)) {
                    this.addTableAttribute(collElement, tableName + "_" + field.getId().toUpperCase());
                    this.addColumnAttribute(keyElement, FOREIGN_KEY_PREFIX + tableName.toLowerCase());
                } else {
                    this.addColumnAttribute(keyElement, FOREIGN_KEY_PREFIX + tableName.toLowerCase() + "_" + field.getId());
                }
            } else {
                this.warnAnyAssociation(persistentNakedClass, field);
                associationType = "many-to-any";
                this.addTableAttribute(collElement, tableName + "_" + field.getId().toUpperCase());
                this.addColumnAttribute(keyElement, FOREIGN_KEY_PREFIX + tableName.toLowerCase());
                Element anyElement = collElement.addElement("many-to-any");
                this.bindAnyAssociation(anyElement, field);
            }
        }
        collElement.addAttribute("lazy", "false");
        if (collectionType.equals("list")) {
            Element listIndexElement = collElement.addElement("list-index");
            if (associationType.startsWith("one")) {
                this.addColumnAttribute(listIndexElement, tableName.toLowerCase() + "_" + field.getId() + "_idx");
            } else {
                this.addColumnAttribute(listIndexElement, "position");
            }
        }
        if (associationType.equals("element")) {
            this.addColumnAttribute(collElement.addElement("element").addAttribute("type", DomainModelResourceType.class.getName()), field.getId().toLowerCase());
        } else if (!associationType.equals("many-to-any")) {
            Element assnElement = collElement.addElement(associationType).addAttribute("class", field.getSpecification().getFullName());
            if (associationType.equals("many-to-many")) {
                PersistentNakedClass associatedClass = this.persistentClasses.getPersistentClass(field.getSpecification().getFullName());
                String associatedTableName = this.deconflictTableName(associatedClass.getTableName());
                this.addColumnAttribute(assnElement, FOREIGN_KEY_PREFIX + associatedTableName.toLowerCase());
            }
        }
        return collElement;
    }

    private String getCollectionType(Class<?> returnType) {
        String type;
        if (returnType.equals(List.class)) {
            type = this.listType;
        } else if (returnType.equals(Set.class) || returnType.equals(SortedSet.class)) {
            type = "set";
        } else if (returnType.equals(Map.class) || returnType.equals(SortedMap.class)) {
            type = "map";
        } else if (returnType.isArray()) {
            type = this.listType;
        } else if (returnType.equals(Vector.class)) {
            type = this.listType;
        } else {
            throw new NakedObjectException("Unsupported collection type " + returnType.getName());
        }
        return type;
    }

    private Class<?> getReturnType(NakedObjectAssociation field, NakedObjectSpecification spec) {
        Method getMethod = this.extractPublicGetMethod(spec, field.getId());
        if (getMethod == null) {
            throw new NakedObjectException("Cannot find get method for collection " + field.getId() + " in spec " + spec);
        }
        return getMethod.getReturnType();
    }

    private Method extractPublicGetMethod(NakedObjectSpecification spec, String name) {
        String nameWithNoSpaces = name.replace(" ", "");
        Method method = null;
        try {
            Class<?> clazz = Class.forName(spec.getFullName());
            try {
                method = clazz.getMethod(this.javaBeanGetterName(nameWithNoSpaces), null);
            }
            catch (NoSuchMethodException nsme) {
                try {
                    method = clazz.getMethod(this.dotNetBeanGetterName(nameWithNoSpaces), null);
                }
                catch (NoSuchMethodException nsme2) {}
            }
        }
        catch (Exception e) {
            throw new NakedObjectException((Throwable)e);
        }
        return method;
    }

    private Method extractGetMethod(NakedObjectSpecification spec, String name) {
        String nameWithNoSpaces = name.replace(" ", "");
        try {
            Class<?> clazz = Class.forName(spec.getFullName());
            return this.getGetMethod(nameWithNoSpaces, clazz);
        }
        catch (Exception e) {
            throw new NakedObjectException((Throwable)e);
        }
    }

    private Method getGetMethod(String name, Class<?> clazz) {
        if (clazz == Object.class || clazz == null) {
            return null;
        }
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(this.javaBeanGetterName(name), null);
        }
        catch (NoSuchMethodException nsme) {
            try {
                method = clazz.getDeclaredMethod(this.dotNetBeanGetterName(name), null);
            }
            catch (NoSuchMethodException nsme2) {
                // empty catch block
            }
        }
        if (method == null) {
            if (clazz.isInterface()) {
                Class<?>[] interfaces = clazz.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    method = this.getGetMethod(name, interfaces[i]);
                    if (method == null) continue;
                    return method;
                }
            } else {
                return this.getGetMethod(name, clazz.getSuperclass());
            }
        }
        return method;
    }

    private void setType(NakedObjectAssociation field, Element property, String attributeName, boolean nakedPropertyAccessor, boolean valueFieldAccess) {
        if (field.getSpecification().isService()) {
            property.addAttribute("type", DomainModelResourceType.class.getName());
            if (valueFieldAccess) {
                property.addAttribute("access", "field");
            }
            return;
        }
        PropertyConverter propertyConverter = this.converterFactory.getConverter(field);
        if (propertyConverter != null) {
            property.addAttribute("type", propertyConverter.getHibernateType());
            if (nakedPropertyAccessor) {
                property.addAttribute("access", NakedPropertyAccessor.class.getName());
            } else if (valueFieldAccess) {
                property.addAttribute("access", "field");
            }
            return;
        }
        String fullName = field.getSpecification().getFullName();
        if (fullName.startsWith(this.applibPrefix)) {
            String type = this.applibReplacementPrefix + fullName.substring(this.applibPrefix.length()) + "Type";
            property.addAttribute(attributeName, type);
        } else if (fullName.startsWith("java.awt.Image")) {
            String type = "org.nakedobjects.nos.store.hibernate.type.AwtImageType";
            property.addAttribute(attributeName, "org.nakedobjects.nos.store.hibernate.type.AwtImageType");
        } else {
            property.addAttribute(attributeName, fullName);
        }
        if (valueFieldAccess) {
            property.addAttribute("access", "field");
        }
    }

    private void bindVersion(Element classElement, boolean valueFieldAccess) {
        Element version = classElement.addElement("version").addAttribute("name", "naked_version").addAttribute("type", ID_TYPE).addAttribute("access", VersionAccessor.class.getName());
        this.setVersionColumnMeta(version, "version", this.versionProperty, this.versionAccess, valueFieldAccess);
        Element user = classElement.addElement("property").addAttribute("name", "naked_modified_by").addAttribute("type", "string").addAttribute("access", UserAccessor.class.getName());
        this.setVersionColumnMeta(user, "modified_by", this.modifiedByProperty, this.modifiedByAccess, valueFieldAccess);
        Element timestamp = classElement.addElement("property").addAttribute("name", "naked_modified_on").addAttribute("type", "timestamp").addAttribute("access", TimestampAccessor.class.getName());
        this.setVersionColumnMeta(timestamp, "modified_on", this.modifiedOnProperty, this.modifiedOnAccess, valueFieldAccess);
    }

    private void setVersionColumnMeta(Element version, String defaultColumn, String property, String access, boolean valueFieldAccess) {
        if (property == null) {
            this.addColumnAttribute(version, defaultColumn);
        } else {
            this.addColumnAttribute(version, property.toLowerCase());
            String propertyWithPrefix = valueFieldAccess ? this.fieldPrefix + property : property;
            version.addElement("meta").addAttribute("attribute", "naked_property").addText(propertyWithPrefix);
            if (access != null) {
                version.addElement("meta").addAttribute("attribute", "naked_access").addText(access);
            } else if (valueFieldAccess) {
                version.addElement("meta").addAttribute("attribute", "naked_access").addText("field");
            }
        }
    }

    public void exportHbmXml(String basedir) {
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        File basedirFile = new File(basedir);
        Iterator<PersistentNakedClass> iter = this.persistentClasses.getPersistentClasses();
        while (iter.hasNext()) {
            String file;
            PersistentNakedClass persistentClass = iter.next();
            LOG.debug((Object)("exporting hbm.xml for " + persistentClass.getName()));
            Document doc = this.createDocument(persistentClass);
            String className = persistentClass.getName();
            String dir = "";
            int pos = className.lastIndexOf(".");
            if (pos < 0) {
                file = className;
            } else {
                file = className.substring(pos + 1);
                dir = className.substring(0, pos).replace(".", FILE_SEPERATOR);
            }
            file = file + ".hbm.xml";
            File outputDir = new File(basedirFile, dir);
            outputDir.mkdirs();
            File outFile = new File(outputDir, file);
            LOG.info((Object)("writing mapping file: " + outFile.getAbsolutePath()));
            this.serializeToXML(doc, outFile, outformat);
        }
    }

    private void serializeToXML(Document doc, File outFile, OutputFormat outformat) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outFile);
            XMLWriter writer = new XMLWriter((OutputStream)fos, outformat);
            writer.write(doc);
            writer.flush();
        }
        catch (Exception e) {
            throw new NakedObjectException((Throwable)e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception ignore) {}
        }
    }
}

