/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.tools.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.hibernate.objectstore.tools.internal.Association;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentNakedClass {
    private PersistentNakedClass parent = null;
    private final List<PersistentNakedClass> subClasses = new ArrayList<PersistentNakedClass>();
    private final NakedObjectSpecification spec;
    private final String name;
    private final boolean root;
    private int referenceCount = 0;
    private NakedObjectAssociation[] uniqueFields = null;
    private String tableName;
    private boolean duplicateUnqualifiedClassName = false;
    private boolean requireVersion = false;
    private final HashMap<String, Association> associations = new HashMap();

    public PersistentNakedClass() {
        this.name = "root";
        this.spec = null;
        this.root = true;
    }

    public PersistentNakedClass(NakedObjectSpecification spec, PersistentNakedClass parent) {
        this.spec = spec;
        this.name = spec.getFullName();
        this.root = false;
        if (parent != null) {
            this.parent = parent;
            parent.subClasses.add(this);
        }
    }

    public void addReference() {
        ++this.referenceCount;
    }

    protected void debugString(StringBuffer sb, String prefix) {
        sb.append("\n" + prefix + this.name);
        if (this.referenceCount > 0) {
            sb.append(" (ref=").append(this.referenceCount).append(")");
        }
        Iterator<PersistentNakedClass> iter = this.subClasses.iterator();
        while (iter.hasNext()) {
            iter.next().debugString(sb, "  " + prefix);
        }
    }

    private void ensureUniqueFieldsResolved() {
        if (this.uniqueFields != null) {
            return;
        }
        if (this.parent.isRoot()) {
            this.uniqueFields = this.spec.getAssociations();
            return;
        }
        NakedObjectAssociation[] parentFields = this.parent.getSpecification().getAssociations();
        HashMap<String, String> parentIds = new HashMap<String, String>();
        for (int i = 0; i < parentFields.length; ++i) {
            if (!parentFields[i].isNotDerived()) continue;
            parentIds.put(parentFields[i].getId(), "");
        }
        ArrayList<NakedObjectAssociation> uniqueList = new ArrayList<NakedObjectAssociation>();
        NakedObjectAssociation[] fields = this.spec.getAssociations();
        for (int i = 0; i < fields.length; ++i) {
            if (parentIds.containsKey(fields[i].getId())) continue;
            uniqueList.add(fields[i]);
        }
        this.uniqueFields = uniqueList.toArray(new NakedObjectAssociation[0]);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistentNakedClass other = (PersistentNakedClass)obj;
        return this.name.equals(other.name);
    }

    public String getName() {
        return this.name;
    }

    public PersistentNakedClass getParent() {
        return this.parent;
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    public NakedObjectSpecification getSpecification() {
        return this.spec;
    }

    public Iterator<PersistentNakedClass> getSubClasses() {
        return this.subClasses.iterator();
    }

    public PersistentNakedClass[] getSubClassesArray() {
        return this.subClasses.toArray(new PersistentNakedClass[0]);
    }

    public String getTableName() {
        return this.tableName;
    }

    public NakedObjectAssociation getUniqueAssociation(String associatedClassName) {
        this.ensureUniqueFieldsResolved();
        NakedObjectAssociation association = null;
        for (int i = 0; i < this.uniqueFields.length; ++i) {
            if (!this.uniqueFields[i].isOneToOneAssociation() && !this.uniqueFields[i].isOneToManyAssociation() || !associatedClassName.equals(this.uniqueFields[i].getSpecification().getFullName())) continue;
            if (association != null) {
                return null;
            }
            association = this.uniqueFields[i];
        }
        return association;
    }

    public NakedObjectAssociation[] getUniqueFields() {
        this.ensureUniqueFieldsResolved();
        return this.uniqueFields;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean hasSubClasses() {
        return this.subClasses.size() > 0;
    }

    public boolean isAbstract() {
        return this.spec.isAbstract();
    }

    public boolean isInterface() {
        try {
            return Class.forName(this.name).isInterface();
        }
        catch (ClassNotFoundException e) {
            throw new NakedObjectException((Throwable)e);
        }
    }

    public boolean isReferenced() {
        return this.referenceCount > 0;
    }

    public boolean isRoot() {
        return this.root;
    }

    public boolean isUniqueAssociation(String associatedClassName) {
        return this.getUniqueAssociation(associatedClassName) != null;
    }

    public void removeFromHierarchy() {
        if (this.hasSubClasses()) {
            Iterator<PersistentNakedClass> iter = this.subClasses.iterator();
            while (iter.hasNext()) {
                iter.next().parent = this.parent;
            }
            this.parent.subClasses.addAll(this.subClasses);
        }
        if (this.parent != null) {
            this.parent.subClasses.remove(this);
            this.parent = null;
        }
    }

    public void setParent(PersistentNakedClass newParent) {
        if (this.parent != null) {
            this.parent.subClasses.remove(this);
        }
        this.parent = newParent;
        newParent.subClasses.add(this);
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String toString() {
        return "PersistentNakedClass[name=" + this.name + (this.root ? " (root)" : "") + (this.referenceCount > 0 ? "(ref=" + this.referenceCount + ")" : "") + "]";
    }

    public boolean isDuplicateUnqualifiedClassName() {
        return this.duplicateUnqualifiedClassName;
    }

    public void setDuplicateUnqualifiedClassName(boolean duplicateUnqualifiedClassName) {
        this.duplicateUnqualifiedClassName = duplicateUnqualifiedClassName;
    }

    public boolean isRequireVersion() {
        return this.requireVersion;
    }

    public void setRequireVersion(boolean requireVersion) {
        this.requireVersion = requireVersion;
    }

    public void addAssociation(String name, Association association) {
        this.associations.put(name, association);
    }

    public Association getAssociation(String name) {
        return this.associations.get(name);
    }

    public boolean hasAssociation(String name) {
        return this.associations.containsKey(name);
    }
}

