package org.nakedobjects.plugins.htmlviewer;

import org.nakedobjects.plugins.htmlviewer.component.Page;
import org.nakedobjects.plugins.htmlviewer.component.ViewPane;
import org.nakedobjects.plugins.htmlviewer.request.Action;
import org.nakedobjects.plugins.htmlviewer.request.Context;
import org.nakedobjects.plugins.htmlviewer.request.Request;
import org.nakedobjects.runtime.authentication.standard.ExplorationSession;
import org.nakedobjects.runtime.context.NakedObjectsContext;



class SetUser implements Action {

    public void execute(final Request request, final Context context, final Page page) {
        final String name = request.getName();
        final ExplorationSession session = (ExplorationSession) NakedObjectsContext.getAuthenticationSession();
        session.setName(name);

        final ViewPane content = page.getViewPane();
        content.setTitle("Exploration User changed to " + name, null);

    }

    public String name() {
        return "setuser";
    }
}

// Copyright (c) Naked Objects Group Ltd.
