package org.nakedobjects.plugins.htmlviewer.object;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.plugins.htmlviewer.component.Page;
import org.nakedobjects.plugins.htmlviewer.request.Action;
import org.nakedobjects.plugins.htmlviewer.request.Context;
import org.nakedobjects.plugins.htmlviewer.request.ForwardRequest;
import org.nakedobjects.plugins.htmlviewer.request.Request;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;



public class Save implements Action {

    public void execute(final Request request, final Context context, final Page page) {
    	
        final NakedObject adapter = context.getMappedObject(request.getObjectId());
        
        // xactn mgmt now done by PersistenceSession#makePersistent()
        // getTransactionManager().startTransaction();
        getPersistenceSession().makePersistent(adapter);
        // getTransactionManager().endTransaction();
        
        // return to view
        request.forward(ForwardRequest.viewObject(request.getObjectId()));
    }

    
    
    ///////////////////////////////////////////////////////
    // Dependencies (from context)
    ///////////////////////////////////////////////////////

    private NakedObjectTransactionManager getTransactionManager() {
        return getPersistenceSession().getTransactionManager();
    }

    private PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    public String name() {
        return "save";
    }

}

// Copyright (c) Naked Objects Group Ltd.
