package org.nakedobjects.plugins.htmlviewer.request;

import java.util.Enumeration;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.UnknownTypeException;
import org.nakedobjects.plugins.htmlviewer.component.Block;
import org.nakedobjects.plugins.htmlviewer.component.Component;
import org.nakedobjects.runtime.context.NakedObjectsContext;


class ObjectHistory {
    private static final Logger LOG = Logger.getLogger(ObjectHistory.class);
    private static final int MAX = 8;
    private final Vector history = new Vector();

    private void add(final HistoryEntry entry) {
        history.removeElement(entry);
        history.addElement(entry);
        LOG.debug("added to history: " + entry);
        if (history.size() > MAX) {
            LOG.debug("purging from history: " + history.elementAt(0));
            history.removeElementAt(0);
        }
    }

    public void debug(final DebugString debug) {
        for (int i = history.size() - 1; i >= 0; i--) {
            final HistoryEntry object = ((HistoryEntry) history.elementAt(i));
            debug.appendln(object.toString());
        }
    }

    public void listObjects(final Context context, final Block navigation) {
        final Block taskBar = context.getComponentFactory().createBlock("history", null);
        taskBar.add(context.getComponentFactory().createHeading("History"));
        for (int i = history.size() - 1; i >= 0; i--) {
            final HistoryEntry item = (HistoryEntry) history.elementAt(i);
            Component icon;
            if (item.type == HistoryEntry.OBJECT) {
                final NakedObject object = context.getMappedObject(item.id);
                
				NakedObjectsContext.getPersistenceSession().resolveImmediately(object);
				
                icon = context.getComponentFactory().createObjectIcon(object, item.id, "item");
            } else if (item.type == HistoryEntry.COLLECTION) {
                final NakedObject object = context.getMappedCollection(item.id);
                icon = context.getComponentFactory().createCollectionIcon(object, item.id);
            } else {
                throw new UnknownTypeException(item);
            }
            taskBar.add(icon);
        }
        navigation.add(taskBar);
    }

    public void addObject(final String idString) {
        add(new HistoryEntry(idString, HistoryEntry.OBJECT));
    }

    public void addCollection(final String idString) {
        add(new HistoryEntry(idString, HistoryEntry.COLLECTION));
    }

    Enumeration elements() {
        return history.elements();
    }
}

class HistoryEntry {
    public static final int OBJECT = 1;
    public static final int COLLECTION = 2;

    final int type;
    final String id;

    public HistoryEntry(final String idString, final int type) {
        this.id = idString;
        this.type = type;
    }

    @Override
    public int hashCode() {
        return id.hashCode();
    }

    @Override
    public boolean equals(final Object obj) {
        return ((HistoryEntry) obj).id.equals(id);
    }

    @Override
    public String toString() {
        return (type == OBJECT ? "object " : "collection ") + id;
    }

}

// Copyright (c) Naked Objects Group Ltd.
