package org.nakedobjects.plugins.htmlviewer.servlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.plugins.htmlviewer.html.HtmlComponentFactory;
import org.nakedobjects.plugins.htmlviewer.html.LogonFormPage;
import org.nakedobjects.plugins.htmlviewer.request.Context;
import org.nakedobjects.runtime.authentication.PasswordAuthenticationRequest;
import org.nakedobjects.runtime.system.internal.monitor.Monitor;


public class Logon extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(Logon.class);
    private static final long serialVersionUID = 1L;

    @Override
    protected void doPost(final HttpServletRequest request, final HttpServletResponse response) throws ServletException,
            IOException {
        final String user = request.getParameter("username");
        final String password = request.getParameter("password");
        final PasswordAuthenticationRequest passwordAuthenticationRequest = new PasswordAuthenticationRequest(user, password);

        if (user == null) {
            prompt(response, "", "", "");
        } else {
            AuthenticationSession session = null;
            session = SessionAccess.authenticate(passwordAuthenticationRequest);
            if (session != null) {
                final Context context = new Context(new HtmlComponentFactory());
                context.setSession(session);
                final HttpSession httpSession = request.getSession(true);
                httpSession.setAttribute("nof-context", context);
                LOG.info("created session: " + httpSession);
                loggedIn(response, user);
            } else {
                prompt(response, user, password, "error");
            }
            // sendResponse(response, user, session);
        }

    }

    @Override
    protected void doGet(final HttpServletRequest arg0, final HttpServletResponse arg1) throws ServletException, IOException {
        doPost(arg0, arg1);
    }

    /*
     * private void sendResponse(final HttpServletResponse response, final String user, final Session session)
     * throws IOException { boolean loggedIn = session != null; if (loggedIn) { loggedIn(response, user); }
     * else { prompt(response, user); } }
     */
    private void prompt(final HttpServletResponse response, final String user, final String password, final String message)
            throws IOException {
        response.setContentType("text/html");
        final HtmlComponentFactory factory = new HtmlComponentFactory();
        final LogonFormPage page = factory.createLogonPage(user, password);
        page.write(response.getWriter());
    }

    private void loggedIn(final HttpServletResponse response, final String user) throws IOException {
        Monitor.addEvent("Web", "Logon - " + user);
        response.sendRedirect("start.app");
    }

}

// Copyright (c) Naked Objects Group Ltd.
