/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.htmlviewer.request;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.plugins.htmlviewer.request.Context;
import org.nakedobjects.runtime.testsystem.ProxyJunit3TestCase;
import org.nakedobjects.runtime.testsystem.TestPojo;

public class ContextSessionDataTest
extends ProxyJunit3TestCase {
    private NakedObject originalAdapter;
    private Oid oid;
    private NakedObject restoredAdapter;

    protected void setUp() throws Exception {
        super.setUp();
        this.originalAdapter = this.system.createTransientTestObject((Object)new TestPojo());
        this.oid = this.originalAdapter.getOid();
        Context context = new Context(null);
        context.mapObject(this.originalAdapter);
        ContextSessionDataTest.assertNotNull((String)"loader still has the object", (Object)ContextSessionDataTest.getAdapterManager().getAdapterFor(this.oid));
        this.system.resetLoader();
        ContextSessionDataTest.assertNull((String)"loader no longer has the object", (Object)ContextSessionDataTest.getAdapterManager().getAdapterFor(this.oid));
        context.restoreAllObjectsToLoader();
        this.restoredAdapter = ContextSessionDataTest.getAdapterManager().getAdapterFor(this.oid);
    }

    public void testExistsInLoader() {
        ContextSessionDataTest.assertNotNull((String)"loaders is missing the object", (Object)ContextSessionDataTest.getAdapterManager().getAdapterFor(this.oid));
        ContextSessionDataTest.assertNotSame((String)"expect the loader to have a new adapter", (Object)this.originalAdapter, (Object)this.restoredAdapter);
    }

    public void testHasSameOid() {
        ContextSessionDataTest.assertEquals((Object)this.originalAdapter.getOid(), (Object)this.restoredAdapter.getOid());
    }

    public void testNotSameAdapter() {
        ContextSessionDataTest.assertNotSame((Object)this.originalAdapter, (Object)this.restoredAdapter);
    }

    public void testSamePojo() {
        ContextSessionDataTest.assertEquals(this.originalAdapter.getObject().getClass(), this.restoredAdapter.getObject().getClass());
    }

    public void testHasSameVersion() {
        ContextSessionDataTest.assertEquals((Object)this.originalAdapter.getVersion(), (Object)this.restoredAdapter.getVersion());
    }

    public void testHasResolveStateOfTransient() {
        ContextSessionDataTest.assertEquals((Object)ResolveState.TRANSIENT, (Object)this.restoredAdapter.getResolveState());
    }
}

