/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.htmlviewer.html;

import java.io.PrintWriter;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionConstants;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionType;
import org.nakedobjects.plugins.htmlviewer.component.Component;

public class MenuItem
implements Component {
    private final String actionId;
    private final String actionName;
    private final String objectId;
    private final String actionDescription;
    private final String reasonDisabled;
    private final boolean takesParameters;
    private final NakedObjectActionType type;

    public MenuItem(String actionId, String actionName, String actionDescription, String reasonDisabled, NakedObjectActionType type, boolean takesParameters, String objectId) {
        this.actionId = actionId;
        this.actionName = actionName;
        this.actionDescription = actionDescription;
        this.reasonDisabled = reasonDisabled;
        this.type = type;
        this.takesParameters = takesParameters;
        this.objectId = objectId;
    }

    public void write(PrintWriter writer) {
        writer.print("<div class=\"menu-item\">");
        if (this.isEmpty(this.reasonDisabled)) {
            this.writeEnabledLink(writer);
        } else {
            this.writeDisabledLink(writer);
        }
        writer.println("</div>");
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private void writeDisabledLink(PrintWriter writer) {
        writer.print("<div class=\"disabled\" title=\"");
        writer.print(this.reasonDisabled);
        writer.print("\">");
        writer.print(this.actionName);
        if (this.takesParameters) {
            writer.print(". . .");
        }
        writer.print("</div>");
    }

    private void writeEnabledLink(PrintWriter writer) {
        writer.print("<a title=\"");
        writer.print(this.actionDescription);
        writer.print("\" href=\"");
        writer.print("method.app?id=");
        writer.print(this.objectId);
        writer.print("&amp;action=");
        writer.print(this.actionId);
        writer.print("\">");
        if (this.type == NakedObjectActionConstants.EXPLORATION) {
            writer.print("[");
            writer.print(this.actionName);
            writer.print("]");
        } else {
            writer.print(this.actionName);
        }
        if (this.takesParameters) {
            writer.print(". . .");
        }
        writer.print("</a>");
    }
}

