/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.htmlviewer.html;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.nakedobjects.plugins.htmlviewer.component.Component;
import org.nakedobjects.plugins.htmlviewer.component.ImageLookup;
import org.nakedobjects.plugins.htmlviewer.component.ViewPane;
import org.nakedobjects.plugins.htmlviewer.html.CompositeComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewDiv
extends CompositeComponent
implements ViewPane {
    private String iconName;
    private String objectId;
    private Component[] menu = new Component[0];
    private String title;
    private List<String> messages = new ArrayList<String>();
    private List<String> warnings = new ArrayList<String>();
    private String description;

    @Override
    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    public void setLink(String objectId) {
        this.objectId = objectId;
    }

    @Override
    public void setMenu(Component[] menu) {
        this.menu = menu;
    }

    @Override
    public void setTitle(String title, String description) {
        this.title = title;
        this.description = description;
    }

    @Override
    public void setWarningsAndMessages(List<String> messages, List<String> warnings) {
        this.messages = messages;
        this.warnings = warnings;
    }

    @Override
    protected void writeAfter(PrintWriter writer) {
        writer.println("</div>");
        writer.println("</div>");
    }

    @Override
    protected void writeBefore(PrintWriter writer) {
        writer.println("<div id=\"view\">");
        this.writeMessages(writer);
        this.writeHeader(writer);
        this.writeMenu(writer);
        writer.println("<div id=\"content\">");
    }

    private void writeMessages(PrintWriter writer) {
        if (this.warnings.size() > 0 || this.messages.size() > 0) {
            writer.print("<div class=\"message-header\">");
            for (String warning : this.warnings) {
                writer.print("<div class=\"warning\">");
                writer.print(warning);
                writer.println("</div>");
            }
            for (String message : this.messages) {
                writer.print("<div class=\"message\">");
                writer.print(message);
                writer.println("</div>");
            }
            writer.print("</div>");
        }
    }

    private void writeMenu(PrintWriter writer) {
        writer.println("<div id=\"menu\">");
        writer.println("<h3>Actions</h3>");
        for (int j = 0; j < this.menu.length; ++j) {
            this.menu[j].write(writer);
        }
        writer.println("</div>");
    }

    private void writeHeader(PrintWriter writer) {
        writer.print("<div class=\"header\"");
        if (this.description != null) {
            writer.print(" title=\"");
            writer.print(this.description);
            writer.print("\"");
        }
        writer.print(">");
        if (this.objectId != null) {
            writer.print("<a href=\"object.app?id=");
            writer.print(this.objectId);
            writer.print("\">");
        }
        if (this.iconName != null) {
            writer.print("<span class=\"header-icon\"><img src=\"");
            writer.print(ImageLookup.image(this.iconName));
            writer.print("\" alt=\"icon\" /></span>");
        }
        writer.print("<span class=\"header-text\"");
        writer.print(">");
        writer.print(this.title);
        writer.println("</span>");
        if (this.objectId != null) {
            writer.print("</a>");
        }
        writer.println("</div>");
    }
}

