/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.htmlviewer.request;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.facets.propparam.multiline.MultiLineFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociationFilters;
import org.nakedobjects.metamodel.spec.feature.OneToManyAssociation;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.plugins.htmlviewer.component.Table;
import org.nakedobjects.plugins.htmlviewer.request.Context;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;

public class TableBuilder {
    public static Table createTable(Context context, String id, NakedObject object, OneToManyAssociation collectionField) {
        NakedObject collection = collectionField.get(object);
        String name = collectionField.getName();
        NakedObjectSpecification type = collectionField.getSpecification();
        String summary = "Table showing elements of " + name + " field";
        return TableBuilder.createTable(context, collectionField != null, collection, summary, type);
    }

    public static Table createTable(Context context, boolean addSelector, NakedObject collection, String summary, NakedObjectSpecification elementType) {
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
        NakedObjectAssociation[] columnAssociations = elementType.getAssociations(NakedObjectAssociationFilters.STATICALLY_VISIBLE_ASSOCIATIONS.and(NakedObjectAssociationFilters.PROPERTIES));
        int len = columnAssociations.length;
        Table table = context.getComponentFactory().createTable(len, addSelector);
        table.setSummary(summary);
        for (NakedObjectAssociation columnAssociation : columnAssociations) {
            table.addColumnHeader(columnAssociation.getName());
        }
        for (NakedObject rowAdapter : facet.iterable(collection)) {
            TableBuilder.getPersistenceSession().resolveImmediately(rowAdapter);
            String elementId = context.mapObject(rowAdapter);
            table.addRowHeader(context.getComponentFactory().createObjectIcon(rowAdapter, elementId, "icon"));
            for (NakedObjectAssociation columnAssociation : columnAssociations) {
                NakedObject columnAdapter = columnAssociation.get(rowAdapter);
                NakedObjectSpecification columnSpec = columnAssociation.getSpecification();
                if (!columnAssociation.isVisible(TableBuilder.getAuthenticationSession(), rowAdapter).isAllowed()) {
                    table.addEmptyCell();
                    continue;
                }
                if (columnSpec.isParseable()) {
                    MultiLineFacet multiline = (MultiLineFacet)columnSpec.getFacet(MultiLineFacet.class);
                    boolean shouldTruncate = multiline != null && multiline.numberOfLines() > 1;
                    String titleString = columnAdapter != null ? columnAdapter.titleString() : null;
                    table.addCell(titleString, shouldTruncate);
                    continue;
                }
                if (columnAdapter == null) {
                    table.addEmptyCell();
                    continue;
                }
                TableBuilder.getPersistenceSession().resolveImmediately(columnAdapter);
                String objectId = context.mapObject(columnAdapter);
                table.addCell(context.getComponentFactory().createObjectIcon(columnAssociation, columnAdapter, objectId, "icon"));
            }
        }
        return table;
    }

    private static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private static AuthenticationSession getAuthenticationSession() {
        return NakedObjectsContext.getAuthenticationSession();
    }
}

