/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.htmlviewer.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.plugins.htmlviewer.WebController;
import org.nakedobjects.plugins.htmlviewer.component.Page;
import org.nakedobjects.plugins.htmlviewer.html.HtmlComponentFactory;
import org.nakedobjects.plugins.htmlviewer.request.Context;
import org.nakedobjects.plugins.htmlviewer.request.Request;
import org.nakedobjects.plugins.htmlviewer.servlet.ServletRequest;
import org.nakedobjects.plugins.htmlviewer.servlet.SessionAccess;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public class Controller
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final Logger LOG = Logger.getLogger(Controller.class);
    private static final String PROPERTY_BASE = "nakedobjects.viewer.html.";
    private WebController controller;
    private static String encoding = "ISO-8859-1";

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding(encoding);
        this.processRequest(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.LOG.info((Object)("request: " + request.getServletPath() + "?" + request.getQueryString()));
        ServletRequest req = new ServletRequest(request);
        if (req.getRequestType() == null) {
            throw new ServletException("No action specified");
        }
        if (!this.controller.actionExists(req)) {
            throw new ServletException("No such action " + req.getRequestType());
        }
        try {
            Context context = this.getContextForRequest(request);
            this.processRequest(request, response, req, context);
        }
        catch (Exception e) {
            this.LOG.error((Object)"exception during request handling", (Throwable)e);
            throw new ServletException("Internal exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(HttpServletRequest request, HttpServletResponse response, Request req, Context context) throws IOException, ServletException {
        if (context.isLoggedIn()) {
            response.setContentType("text/html");
            try {
                SessionAccess.startRequest(context.getSession());
                Page page = this.controller.generatePage(context, req);
                if (context.isValid()) {
                    if (this.controller.isDebug()) {
                        this.controller.addDebug(page, req);
                        this.addDebug(request, page);
                    }
                    PrintWriter writer = response.getWriter();
                    page.write(writer);
                }
                response.sendRedirect("logon.app");
            }
            finally {
                SessionAccess.endRequest(context.getSession());
                if (!context.isLoggedIn()) {
                    HttpSession httpSession = request.getSession(false);
                    this.LOG.info((Object)("dropping session: " + httpSession));
                }
            }
        } else {
            response.sendRedirect("logon.app");
        }
    }

    private Context getContextForRequest(HttpServletRequest request) {
        Context context = (Context)request.getSession(true).getAttribute("nof-context");
        if (context == null || !context.isValid()) {
            context = new Context(new HtmlComponentFactory());
            request.getSession(true).setAttribute("nof-context", (Object)context);
        }
        return context;
    }

    private void addDebug(HttpServletRequest request, Page page) {
        page.addDebug("Servlet path", request.getServletPath());
        page.addDebug("Query string", request.getQueryString());
        page.addDebug("Context path", request.getContextPath());
        page.addDebug("Path info", request.getPathInfo());
    }

    public void init(ServletConfig arg0) throws ServletException {
        super.init(arg0);
        this.controller = new WebController();
        NakedObjectConfiguration configuration = NakedObjectsContext.getConfiguration();
        this.controller.setDebug(configuration.getBoolean("nakedobjects.viewer.html.debug"));
        this.controller.init();
        encoding = configuration.getString("nakedobjects.viewer.html.encoding", encoding);
    }
}

