/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.htmlviewer.servlet;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.nakedobjects.applib.fixtures.LogonFixture;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.PasswordAuthenticationRequest;
import org.nakedobjects.runtime.authentication.standard.ExplorationSession;
import org.nakedobjects.runtime.authentication.standard.SimpleSession;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.system.DeploymentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionAccess {
    private static final Logger LOG = Logger.getLogger(SessionAccess.class);
    private static SessionAccess instance;
    private final List<Object> sessions = new ArrayList<Object>();
    private final AuthenticationManager authenticationManager;
    private DeploymentType deploymentType;
    private LogonFixture logonFixture;

    public static void createInstance(AuthenticationManager authenticationManager) {
        new SessionAccess(authenticationManager);
    }

    public static void createInstance(AuthenticationManager authenticationManager, DeploymentType deploymentType, LogonFixture logonFixture) {
        new SessionAccess(authenticationManager, deploymentType, logonFixture);
    }

    public static List<Object> getSessions() {
        return SessionAccess.instance.sessions;
    }

    public static void addSession(Object session) {
        SessionAccess.instance.sessions.add(session);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("session started " + session));
        }
    }

    public static void removeSession(Object session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("session ended " + session));
        }
        SessionAccess.instance.sessions.remove(session);
    }

    public static AuthenticationSession authenticate(PasswordAuthenticationRequest passwordAuthenticationRequest) {
        return instance.authenticateInstance(passwordAuthenticationRequest);
    }

    public static void logoffUser(AuthenticationSession session) {
        SessionAccess.getAuthenticationManager().closeSession(session);
    }

    private static AuthenticationManager getAuthenticationManager() {
        if (instance == null) {
            throw new IllegalStateException("Server initialisation failed, or not defined as a context listener");
        }
        return SessionAccess.instance.authenticationManager;
    }

    public static void startRequest(AuthenticationSession authSession) {
        NakedObjectsContext.openSession((AuthenticationSession)authSession);
    }

    public static void endRequest(AuthenticationSession authSession) {
        if (NakedObjectsContext.inSession()) {
            NakedObjectsContext.closeSession();
        }
    }

    public static boolean inExplorationMode() {
        return instance.inExplorationModeInstance();
    }

    private SessionAccess(AuthenticationManager authenticationManager) {
        this(authenticationManager, DeploymentType.SERVER, null);
    }

    private SessionAccess(AuthenticationManager authenticationManager, DeploymentType deploymentType, LogonFixture logonFixture) {
        this.authenticationManager = authenticationManager;
        this.deploymentType = deploymentType;
        this.logonFixture = logonFixture;
        instance = this;
    }

    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public LogonFixture getLogonFixture() {
        return this.logonFixture;
    }

    private AuthenticationSession authenticateInstance(PasswordAuthenticationRequest passwordAuthenticationRequest) {
        if ((this.deploymentType.isExploring() || this.deploymentType.isPrototyping()) && this.logonFixture != null) {
            return new SimpleSession(this.logonFixture.getUsername(), this.logonFixture.getRoles());
        }
        if (this.deploymentType.isExploring()) {
            return new ExplorationSession();
        }
        return this.authenticationManager.authenticate((AuthenticationRequest)passwordAuthenticationRequest);
    }

    private boolean inExplorationModeInstance() {
        return this.deploymentType.isExploring();
    }
}

