/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.htmlviewer.task;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.facets.propparam.multiline.MultiLineFacet;
import org.nakedobjects.metamodel.facets.propparam.typicallength.TypicalLengthFacet;
import org.nakedobjects.metamodel.facets.propparam.validate.maxlength.MaxLengthFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionConstants;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociationFilters;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.metamodel.util.NakedObjectUtils;
import org.nakedobjects.plugins.htmlviewer.component.Page;
import org.nakedobjects.plugins.htmlviewer.request.Context;
import org.nakedobjects.plugins.htmlviewer.request.Task;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;

public class EditTask
extends Task {
    private final NakedObjectAssociation[] fields;
    private final String newType;

    private static int size(NakedObject object) {
        NakedObjectAssociation[] fields = object.getSpecification().getAssociations(NakedObjectAssociationFilters.dynamicallyVisible((AuthenticationSession)NakedObjectsContext.getAuthenticationSession(), (NakedObject)object));
        return fields.length;
    }

    private static boolean skipField(NakedObject object, NakedObjectAssociation fld) {
        return fld.isOneToManyAssociation() || fld.isUsable(NakedObjectsContext.getAuthenticationSession(), object).isVetoed();
    }

    EditTask(Context context, NakedObject object) {
        super(context, "Edit", "", object, EditTask.size(object));
        NakedObjectAssociation[] allFields = object.getSpecification().getAssociations(NakedObjectAssociationFilters.dynamicallyVisible((AuthenticationSession)NakedObjectsContext.getAuthenticationSession(), (NakedObject)object));
        this.fields = new NakedObjectAssociation[this.names.length];
        int i = 0;
        for (int j = 0; j < allFields.length; ++j) {
            NakedObjectAssociation fld;
            this.fields[i] = fld = allFields[j];
            this.names[i] = fld.getName();
            this.descriptions[i] = fld.getDescription();
            Consent usableByUser = fld.isUsable(NakedObjectsContext.getAuthenticationSession(), object);
            if (usableByUser.isVetoed()) {
                this.descriptions[i] = usableByUser.getReason();
            }
            this.fieldSpecifications[i] = fld.getSpecification();
            this.initialState[i] = fld.get(object);
            if (EditTask.skipField(object, fld)) {
                this.readOnly[i] = true;
            } else {
                this.readOnly[i] = false;
                boolean bl = this.optional[i] = !fld.isMandatory();
                if (this.fieldSpecifications[i].isParseable()) {
                    MultiLineFacet multilineFacet = (MultiLineFacet)fld.getFacet(MultiLineFacet.class);
                    this.noLines[i] = multilineFacet.numberOfLines();
                    this.wraps[i] = !multilineFacet.preventWrapping();
                    MaxLengthFacet maxLengthFacet = (MaxLengthFacet)fld.getFacet(MaxLengthFacet.class);
                    this.maxLength[i] = maxLengthFacet.value();
                    TypicalLengthFacet typicalLengthFacet = (TypicalLengthFacet)fld.getFacet(TypicalLengthFacet.class);
                    this.typicalLength[i] = typicalLengthFacet.value();
                }
            }
            ++i;
        }
        boolean isNew = object.getResolveState() == ResolveState.TRANSIENT;
        this.newType = isNew ? this.getTarget(context).getSpecification().getSingularName() : null;
    }

    protected NakedObject[][] getOptions(Context context, int from, int len) {
        NakedObject target = this.getTarget(context);
        NakedObject[][] options = new NakedObject[len][];
        int i = from;
        for (int j = 0; j < len; ++j) {
            if (!EditTask.skipField(target, this.fields[i])) {
                options[j] = this.fields[i].getChoices(target);
            }
            ++i;
        }
        return options;
    }

    public void checkForValidity(Context context) {
        NakedObject target = this.getTarget(context);
        NakedObject[] entries = this.getEntries(context);
        int len = this.fields.length;
        for (int i = 0; i < len; ++i) {
            NakedObjectAssociation fld;
            if (this.readOnly[i] || this.errors[i] != null || !(fld = this.fields[i]).isOneToOneAssociation()) continue;
            OneToOneAssociation oneToOneAssociation = (OneToOneAssociation)fld;
            NakedObject entryReference = entries[i];
            NakedObject currentReference = oneToOneAssociation.get(target);
            if (currentReference == entryReference) continue;
            Consent valueValid = ((OneToOneAssociation)fld).isAssociationValid(target, entryReference);
            this.errors[i] = valueValid.getReason();
        }
        if (target.isTransient()) {
            this.saveState(target, entries);
            Consent isValid = target.getSpecification().isValid(target);
            this.error = isValid.isVetoed() ? isValid.getReason() : null;
        }
    }

    public NakedObject completeTask(Context context, Page page) {
        NakedObject targetAdapter = this.getTarget(context);
        NakedObject[] entryAdapters = this.getEntries(context);
        if (targetAdapter.isTransient()) {
            NakedObjectAction action = targetAdapter.getSpecification().getObjectAction(NakedObjectActionConstants.USER, "save", new NakedObjectSpecification[0]);
            if (action == null) {
                EditTask.getPersistenceSession().makePersistent(targetAdapter);
            } else {
                action.execute(targetAdapter, new NakedObject[0]);
            }
        } else {
            this.saveState(targetAdapter, entryAdapters);
        }
        return targetAdapter;
    }

    private void saveState(NakedObject targetAdapter, NakedObject[] entryAdapters) {
        for (int i = 0; i < this.fields.length; ++i) {
            NakedObjectAssociation fld = this.fields[i];
            NakedObject entryAdapter = entryAdapters[i];
            boolean isReadOnly = this.readOnly[i];
            if (isReadOnly || !fld.isOneToOneAssociation()) continue;
            OneToOneAssociation oneToOneAssociation = (OneToOneAssociation)fld;
            Object entryPojo = NakedObjectUtils.unwrap((NakedObject)entryAdapter);
            if (entryPojo == null) {
                if (oneToOneAssociation.get(targetAdapter) == null) continue;
                oneToOneAssociation.clearAssociation(targetAdapter);
                continue;
            }
            NakedObject currentAdapter = oneToOneAssociation.get(targetAdapter);
            Object currentPojo = NakedObjectUtils.unwrap((NakedObject)currentAdapter);
            if (currentAdapter != null && currentPojo != null && currentPojo.equals(entryPojo)) continue;
            oneToOneAssociation.setAssociation(targetAdapter, entryAdapter);
        }
    }

    protected boolean simpleField(NakedObjectSpecification type, int i) {
        return !this.fields[i].hasChoices() || super.simpleField(type, i);
    }

    public boolean isEditing() {
        return true;
    }

    public String getName() {
        if (this.newType == null) {
            return super.getName();
        }
        return "New " + this.newType;
    }

    private static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }
}

