/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.htmlviewer.task;

import java.util.List;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.exceptions.UnknownTypeException;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.spec.Persistability;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.plugins.htmlviewer.component.Page;
import org.nakedobjects.plugins.htmlviewer.request.Action;
import org.nakedobjects.plugins.htmlviewer.request.ActionException;
import org.nakedobjects.plugins.htmlviewer.request.Context;
import org.nakedobjects.plugins.htmlviewer.request.ForwardRequest;
import org.nakedobjects.plugins.htmlviewer.request.Request;
import org.nakedobjects.plugins.htmlviewer.task.MethodTask;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.transaction.messagebroker.MessageBroker;

public final class InvokeMethod
implements Action {
    public void execute(Request request, Context context, Page page) {
        String idString = request.getObjectId();
        if (idString == null) {
            throw new ActionException("Task no longer in progress");
        }
        NakedObject target = context.getMappedObject(idString);
        String id = request.getActionId();
        NakedObjectAction action = context.getMappedAction(id);
        if (action == null) {
            throw new ActionException("No such action: " + id);
        }
        boolean executeImmediately = false;
        boolean isContributedMethod = action.isContributed();
        if (action.getParameterCount() == 0) {
            executeImmediately = true;
        } else if (action.getParameterCount() == 1 && isContributedMethod && target.getSpecification().isOfType(action.getParameters()[0].getSpecification())) {
            executeImmediately = true;
        }
        if (executeImmediately) {
            NakedObject[] nakedObjectArray;
            if (isContributedMethod) {
                NakedObject[] nakedObjectArray2 = new NakedObject[1];
                nakedObjectArray = nakedObjectArray2;
                nakedObjectArray2[0] = target;
            } else {
                nakedObjectArray = null;
            }
            NakedObject[] parameters = nakedObjectArray;
            NakedObject result = action.execute(target, parameters);
            MessageBroker broker = NakedObjectsContext.getMessageBroker();
            List messages = broker.getMessages();
            List warnings = broker.getWarnings();
            context.setMessagesAndWarnings(messages, warnings);
            String targetId = context.mapObject(target);
            InvokeMethod.displayMethodResult(request, context, page, result, targetId);
        } else {
            MethodTask methodTask = new MethodTask(context, target, action);
            context.addTaskCrumb(methodTask);
            request.forward(ForwardRequest.task(methodTask));
        }
    }

    static void displayMethodResult(Request request, Context context, Page page, NakedObject result, String targetId) {
        if (result == null) {
            request.forward(ForwardRequest.viewService(targetId));
        } else if (result.getSpecification().isCollection()) {
            CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)result);
            if (facet.size(result) == 1) {
                InvokeMethod.forwardObjectResult(request, context, facet.firstElement(result));
            } else {
                InvokeMethod.forwardCollectionResult(request, context, result);
            }
        } else if (result.getSpecification().isObject()) {
            InvokeMethod.forwardObjectResult(request, context, result);
        } else {
            throw new UnknownTypeException(result.getSpecification().getFullName());
        }
    }

    static void forwardCollectionResult(Request request, Context context, NakedObject coll) {
        String collectionId = context.mapCollection(coll);
        request.forward(ForwardRequest.listCollection(collectionId));
    }

    static void forwardObjectResult(Request request, Context context, NakedObject resultAdapter) {
        String objectId = context.mapObject(resultAdapter);
        if (resultAdapter.isTransient() && resultAdapter.getSpecification().persistability() == Persistability.USER_PERSISTABLE) {
            request.forward(ForwardRequest.editObject(objectId));
        } else if (resultAdapter.getSpecification().isService()) {
            request.forward(ForwardRequest.viewService(objectId));
        } else {
            request.forward(ForwardRequest.viewObject(objectId));
        }
    }

    public String name() {
        return "method";
    }
}

