/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.html.context;

import java.util.Enumeration;
import java.util.Vector;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.plugins.html.context.Context;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;

public class CollectionMapping {
    private final Vector list = new Vector();
    private final NakedObjectSpecification elementSpecification;

    public CollectionMapping(Context context, NakedObject collection) {
        TypeOfFacet typeOfFacet = (TypeOfFacet)collection.getSpecification().getFacet(TypeOfFacet.class);
        this.elementSpecification = typeOfFacet.valueSpec();
        CollectionFacet collectionFacet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
        Enumeration elements = collectionFacet.elements(collection);
        while (elements.hasMoreElements()) {
            NakedObject element = (NakedObject)elements.nextElement();
            this.list.add(context.mapObject(element));
        }
    }

    public NakedObject getCollection(Context context) {
        Vector<Object> elements = new Vector<Object>();
        Enumeration e = this.list.elements();
        while (e.hasMoreElements()) {
            String elementId = (String)e.nextElement();
            NakedObject adapter = context.getMappedObject(elementId);
            elements.add(adapter.getObject());
        }
        return CollectionMapping.getAdapterManager().adapterFor(elements);
    }

    public NakedObjectSpecification getElementSpecification() {
        return this.elementSpecification;
    }

    public void debug(DebugString debug) {
        debug.indent();
        Enumeration e = this.list.elements();
        while (e.hasMoreElements()) {
            String elementId = (String)e.nextElement();
            debug.appendln(elementId);
        }
        debug.unindent();
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        return this.equals((CollectionMapping)other);
    }

    public boolean equals(CollectionMapping other) {
        return this.list.equals(other.list);
    }

    public boolean contains(String id) {
        Enumeration e = this.list.elements();
        while (e.hasMoreElements()) {
            String elementId = (String)e.nextElement();
            if (!elementId.equals(id)) continue;
            return true;
        }
        return false;
    }

    public Enumeration elements() {
        return this.list.elements();
    }

    private static AdapterManager getAdapterManager() {
        return CollectionMapping.getPersistenceSession().getAdapterManager();
    }

    private static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }
}

