/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.html.context;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.html.context.ObjectMapping;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;

public class PersistentObjectMapping
implements ObjectMapping {
    private final Oid oid;
    private final NakedObjectSpecification specification;
    private Version version;

    public PersistentObjectMapping(NakedObject adapter) {
        this.oid = adapter.getOid();
        Assert.assertFalse((String)"OID is for transient", (boolean)this.oid.isTransient());
        Assert.assertFalse((String)"adapter is for transient", (boolean)adapter.isTransient());
        this.specification = adapter.getSpecification();
        this.version = adapter.getVersion();
    }

    public void debug(DebugString debug) {
        debug.appendln(this.specification.getFullName());
        if (this.version != null) {
            debug.appendln(this.version.toString());
        }
    }

    public Oid getOid() {
        return this.oid;
    }

    public NakedObject getObject() {
        return PersistentObjectMapping.getPersistenceSession().loadObject(this.oid, this.specification);
    }

    public int hashCode() {
        return this.oid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj.getClass() == PersistentObjectMapping.class) {
            return ((PersistentObjectMapping)obj).oid.equals(this.oid);
        }
        return false;
    }

    public String toString() {
        return (this.specification == null ? "null" : this.specification.getSingularName()) + " : " + this.oid + " : " + this.version;
    }

    public Version getVersion() {
        return this.version;
    }

    public void checkVersion(NakedObject object) {
        object.checkLock(this.getVersion());
    }

    public void updateVersion() {
        NakedObject adapter = PersistentObjectMapping.getAdapterManager().getAdapterFor(this.oid);
        this.version = adapter.getVersion();
    }

    public void restoreToLoader() {
        Oid oid = this.getOid();
        NakedObject adapter = PersistentObjectMapping.getPersistenceSession().recreateAdapter(oid, this.specification);
        adapter.setOptimisticLock(this.getVersion());
    }

    private static AdapterManager getAdapterManager() {
        return PersistentObjectMapping.getPersistenceSession().getAdapterManager();
    }

    private static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }
}

