/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.html.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.plugins.html.component.Page;
import org.nakedobjects.plugins.html.component.html.HtmlComponentFactory;
import org.nakedobjects.plugins.html.context.Context;
import org.nakedobjects.plugins.html.request.Request;
import org.nakedobjects.plugins.html.request.ServletRequest;
import org.nakedobjects.plugins.html.servlet.internal.WebController;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public class ControllerServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(ControllerServlet.class);
    private String encoding = "ISO-8859-1";
    private WebController controller;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.encoding = ControllerServlet.getConfiguration().getString("nakedobjects.viewer.html.encoding", this.encoding);
        this.controller = new WebController();
        this.controller.setDebug(ControllerServlet.getConfiguration().getBoolean("nakedobjects.viewer.html.debug"));
        this.controller.init();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding(this.encoding);
        this.processRequest(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOG.info((Object)("request: " + request.getServletPath() + "?" + request.getQueryString()));
        ServletRequest req = new ServletRequest(request);
        if (req.getRequestType() == null) {
            throw new ServletException("No action specified");
        }
        if (!this.controller.actionExists(req)) {
            throw new ServletException("No such action " + req.getRequestType());
        }
        try {
            Context context = this.getContextForRequest(request);
            this.processRequest(request, response, req, context);
        }
        catch (Exception e) {
            LOG.error((Object)"exception during request handling", (Throwable)e);
            throw new ServletException("Internal exception", (Throwable)e);
        }
    }

    private Context getContextForRequest(HttpServletRequest request) {
        AuthenticationSession authenticationSession = ControllerServlet.getAuthenticationSession();
        Context context = (Context)authenticationSession.getAttribute("nof-context");
        if (context == null || !context.isValid()) {
            context = new Context(new HtmlComponentFactory());
            authenticationSession.setAttribute("nof-context", (Object)context);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(HttpServletRequest request, HttpServletResponse response, Request req, Context context) throws IOException, ServletException {
        response.setContentType("text/html");
        try {
            Page page = this.controller.generatePage(context, req);
            if (context.isValid()) {
                if (this.controller.isDebug()) {
                    this.controller.addDebug(page, req);
                    this.addDebug(request, page);
                }
                PrintWriter writer = response.getWriter();
                page.write(writer);
            } else {
                response.sendRedirect("logon.app");
            }
        }
        finally {
            if (!context.isLoggedIn()) {
                HttpSession httpSession = request.getSession(false);
                LOG.info((Object)("dropping session: " + httpSession));
            }
        }
    }

    private void addDebug(HttpServletRequest request, Page page) {
        page.addDebug("Servlet path", request.getServletPath());
        page.addDebug("Query string", request.getQueryString());
        page.addDebug("Context path", request.getContextPath());
        page.addDebug("Path info", request.getPathInfo());
    }

    private static AuthenticationSession getAuthenticationSession() {
        return NakedObjectsContext.getAuthenticationSession();
    }

    private static NakedObjectConfiguration getConfiguration() {
        return NakedObjectsContext.getConfiguration();
    }
}

