/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.html.servlet.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectApplicationException;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.facets.hide.HiddenFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.html.action.Action;
import org.nakedobjects.plugins.html.action.ActionException;
import org.nakedobjects.plugins.html.action.ChangeContext;
import org.nakedobjects.plugins.html.action.LogOut;
import org.nakedobjects.plugins.html.action.Welcome;
import org.nakedobjects.plugins.html.action.edit.AddItemToCollection;
import org.nakedobjects.plugins.html.action.edit.EditObject;
import org.nakedobjects.plugins.html.action.edit.RemoveItemFromCollection;
import org.nakedobjects.plugins.html.action.edit.Save;
import org.nakedobjects.plugins.html.action.misc.About;
import org.nakedobjects.plugins.html.action.misc.SetUser;
import org.nakedobjects.plugins.html.action.misc.SwapUser;
import org.nakedobjects.plugins.html.action.view.CollectionView;
import org.nakedobjects.plugins.html.action.view.FieldCollectionView;
import org.nakedobjects.plugins.html.action.view.ObjectView;
import org.nakedobjects.plugins.html.action.view.ServiceView;
import org.nakedobjects.plugins.html.component.Block;
import org.nakedobjects.plugins.html.component.Component;
import org.nakedobjects.plugins.html.component.ComponentFactory;
import org.nakedobjects.plugins.html.component.DebugPane;
import org.nakedobjects.plugins.html.component.Page;
import org.nakedobjects.plugins.html.context.Context;
import org.nakedobjects.plugins.html.context.ObjectLookupException;
import org.nakedobjects.plugins.html.crumb.Crumb;
import org.nakedobjects.plugins.html.image.ImageLookup;
import org.nakedobjects.plugins.html.request.Request;
import org.nakedobjects.plugins.html.task.InvokeMethod;
import org.nakedobjects.plugins.html.task.TaskLookupException;
import org.nakedobjects.plugins.html.task.TaskStep;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;
import org.nakedobjects.runtime.system.internal.monitor.Monitor;
import org.nakedobjects.runtime.userprofile.UserProfile;
import org.nakedobjects.runtime.util.Dump;

public class WebController {
    private static final String ERROR_REASON = "This error occurs when you go back to a page using the browsers back button.  To avoid this error in the future please avoid using the back button";
    private final Map actions = new HashMap();
    private boolean isDebug;
    private final Logger LOG = Logger.getLogger(WebController.class);
    private final Logger ACCESS_LOG = Logger.getLogger((String)"access_log");

    public boolean actionExists(Request req) {
        return this.actions.containsKey(req.getRequestType());
    }

    protected void addAction(Action action) {
        this.actions.put(action.name(), action);
    }

    private void addCrumbs(Context context, Page page) {
        Crumb[] crumbs = context.getCrumbs();
        String[] names = new String[crumbs.length];
        boolean[] isLinked = context.isLinked();
        for (int i = 0; i < crumbs.length; ++i) {
            names[i] = crumbs[i].title();
        }
        ComponentFactory factory = context.getComponentFactory();
        Component breadCrumbs = factory.createBreadCrumbs(names, isLinked);
        page.setCrumbs(breadCrumbs);
    }

    public void addDebug(Page page, Request req) {
        page.addDebug("<a href=\"debug.app\">Debug</a>");
        String id = req.getObjectId();
        if (id != null) {
            page.addDebug("<a href=\"dump.app?id=" + id + "\">Object</a>");
            page.addDebug("<a href=\"spec.app?id=" + id + "\">Spec</a>");
        }
        page.addDebug("<a href=\"about.app\">About</a>");
        page.addDebug("<a href=\"debugoff.app\">Debug off</a>");
    }

    public Page generatePage(Context context, Request request) {
        context.restoreAllObjectsToLoader();
        Page page = context.getComponentFactory().createPage();
        this.pageHeader(context, page);
        Block navigation = page.getNavigation();
        Block optionBar = context.getComponentFactory().createBlock("options", null);
        optionBar.add(context.getComponentFactory().createHeading("Options"));
        Block block = context.getComponentFactory().createBlock("item", null);
        Component option = context.getComponentFactory().createLink("logout", "Log Out", "End the current session");
        block.add(option);
        optionBar.add(block);
        block = context.getComponentFactory().createBlock("item", null);
        option = context.getComponentFactory().createLink("about", "About", "Details about this application");
        block.add(option);
        optionBar.add(block);
        boolean isExploring = NakedObjectsContext.getDeploymentType().isExploring();
        if (isExploring) {
            block = context.getComponentFactory().createBlock("item", null);
            option = context.getComponentFactory().createLink("swapuser", "Swap User", "Swap the exploration user");
            block.add(option);
            optionBar.add(block);
        }
        navigation.add(optionBar);
        this.listServices(context, navigation);
        this.listHistory(context, navigation);
        Monitor.addEvent((String)"Web", (String)("Request " + request));
        this.runAction(context, request, page);
        this.addCrumbs(context, page);
        if (NakedObjectsContext.inSession() && NakedObjectsContext.inTransaction()) {
            NakedObjectsContext.getUpdateNotifier().clear();
        }
        return page;
    }

    public void init() {
        this.addAction(new About());
        this.addAction(new SwapUser());
        this.addAction(new SetUser());
        this.addAction(new DebugView());
        this.addAction(new DebugSpecification());
        this.addAction(new DebugObject());
        this.addAction(new Welcome());
        this.addAction(new ObjectView());
        this.addAction(new CollectionView());
        this.addAction(new FieldCollectionView());
        this.addAction(new InvokeMethod());
        this.addAction(new TaskStep());
        this.addAction(new EditObject());
        this.addAction(new Save());
        this.addAction(new ServiceView());
        this.addAction(new LogOut());
        this.addAction(new RemoveItemFromCollection());
        this.addAction(new AddItemToCollection());
        this.addAction(new ChangeContext());
        this.addAction(new DebugOn(this));
        this.addAction(new DebugOff(this));
        Logger.getLogger(this.getClass()).info((Object)"init");
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    private void listHistory(Context context, Block navigation) {
        context.listHistory(context, navigation);
    }

    private void listServices(Context context, Block navigationBar) {
        Block taskBar = context.getComponentFactory().createBlock("services", null);
        taskBar.add(context.getComponentFactory().createHeading("Services"));
        AdapterManager adapterManager = NakedObjectsContext.getPersistenceSession().getAdapterManager();
        List services = this.getUserProfile().getPerspective().getServices();
        for (Object service : services) {
            NakedObject serviceAdapter = adapterManager.adapterFor(service);
            if (serviceAdapter == null) {
                this.LOG.warn((Object)("unable to find service Id: " + service + "; skipping"));
                continue;
            }
            if (this.isHidden(serviceAdapter)) continue;
            String serviceMapId = context.mapObject(serviceAdapter);
            taskBar.add(this.createServiceComponent(context, serviceMapId, serviceAdapter));
        }
        navigationBar.add(taskBar);
    }

    private Component createServiceComponent(Context context, String serviceMapId, NakedObject serviceNO) {
        String serviceName = serviceNO.titleString();
        String serviceIcon = serviceNO.getIconName();
        return context.getComponentFactory().createService(serviceMapId, serviceName, serviceIcon);
    }

    private boolean isHidden(NakedObject serviceNO) {
        NakedObjectSpecification serviceNoSpec = serviceNO.getSpecification();
        boolean isHidden = serviceNoSpec.getFacet(HiddenFacet.class) != null;
        return isHidden;
    }

    private void pageHeader(Context context, Page page) {
        page.getPageHeader().add(context.getComponentFactory().createInlineBlock("none", "", null));
    }

    private void runAction(Context context, Request request, Page page) {
        try {
            this.ACCESS_LOG.info((Object)("request " + request.toString()));
            Request r = request;
            DebugString debug = new DebugString();
            debug.startSection("Request");
            debug.appendln("http", (Object)request.toString());
            debug.endSection();
            do {
                String error;
                Action action = (Action)this.actions.get(r.getRequestType());
                try {
                    action.execute(r, context, page);
                }
                catch (ObjectLookupException e) {
                    error = "The object/service you selected has timed out.  Please navigate to the object via the history bar.";
                    this.displayError(context, page, "The object/service you selected has timed out.  Please navigate to the object via the history bar.");
                }
                catch (TaskLookupException e) {
                    error = "The task you went back to has already been completed or cancelled.  Please start the task again.";
                    this.displayError(context, page, "The task you went back to has already been completed or cancelled.  Please start the task again.");
                }
                r = r.getForward();
                if (r == null) continue;
                this.LOG.debug((Object)("forward to " + r));
            } while (r != null);
            if (this.LOG.isDebugEnabled()) {
                context.debug(debug);
                debug.appendln();
                NakedObjectsContext.getSession((String)this.getExecutionContextId()).debugAll(debug);
                this.LOG.debug((Object)debug.toString());
            }
        }
        catch (ActionException e) {
            page.setTitle("Error");
            page.getViewPane().setTitle("Error", "Action Exception");
            this.LOG.error((Object)("ActionException, executing action " + request.getRequestType()), (Throwable)((Object)e));
            page.getViewPane().add(context.getComponentFactory().createErrorMessage((Exception)((Object)e), this.isDebug));
        }
        catch (NakedObjectApplicationException e) {
            page.setTitle("Error");
            page.getViewPane().setTitle("Error", "Application Exception");
            this.LOG.error((Object)("ApplicationException, executing action " + request.getRequestType()), (Throwable)e);
            page.getViewPane().add(context.getComponentFactory().createErrorMessage((Exception)((Object)e), this.isDebug));
        }
        catch (NakedObjectException e) {
            page.setTitle("Error");
            page.getViewPane().setTitle("Error", "System Exception");
            this.LOG.error((Object)("NakedObjectRuntimeException, executing action " + request.getRequestType()), (Throwable)e);
            page.getViewPane().add(context.getComponentFactory().createErrorMessage((Exception)((Object)e), true));
        }
        catch (RuntimeException e) {
            page.setTitle("Error");
            page.getViewPane().setTitle("Error", "System Exception");
            this.LOG.error((Object)("RuntimeException, executing action " + request.getRequestType()), (Throwable)e);
            page.getViewPane().add(context.getComponentFactory().createErrorMessage(e, true));
        }
    }

    private void displayError(Context context, Page page, String errorMessage) {
        page.setTitle("Error");
        page.getViewPane().setTitle("Error", "");
        Block block1 = context.getComponentFactory().createBlock("error", "");
        block1.add(context.getComponentFactory().createInlineBlock("", errorMessage, ""));
        page.getViewPane().add(block1);
        Block block2 = context.getComponentFactory().createBlock("text", "");
        block2.add(context.getComponentFactory().createInlineBlock("", ERROR_REASON, ""));
        page.getViewPane().add(block2);
    }

    public void setDebug(boolean on) {
        this.isDebug = on;
    }

    private UserProfile getUserProfile() {
        return NakedObjectsContext.getUserProfile();
    }

    private String getExecutionContextId() {
        return NakedObjectsContext.getSessionId();
    }

    private class DebugOff
    implements Action {
        private final WebController controller;

        public DebugOff(WebController controller) {
            this.controller = controller;
        }

        public void execute(Request request, Context context, Page page) {
            this.controller.setDebug(false);
        }

        public String name() {
            return "debugoff";
        }
    }

    private class DebugOn
    implements Action {
        private final WebController controller;

        public DebugOn(WebController controller) {
            this.controller = controller;
        }

        public void execute(Request request, Context context, Page page) {
            this.controller.setDebug(true);
        }

        public String name() {
            return "debugon";
        }
    }

    private class DebugObject
    implements Action {
        private DebugObject() {
        }

        public void execute(Request request, Context context, Page page) {
            DebugPane debugPane = context.getComponentFactory().createDebugPane();
            page.setDebug(debugPane);
            debugPane.addSection("Adapter");
            NakedObject object = context.getMappedObject(request.getObjectId());
            debugPane.appendln(Dump.adapter((NakedObject)object));
            debugPane.addSection("Graph");
            debugPane.appendln(Dump.graph((NakedObject)object, (AuthenticationSession)NakedObjectsContext.getAuthenticationSession()));
        }

        public String name() {
            return "dump";
        }
    }

    private class DebugSpecification
    implements Action {
        private DebugSpecification() {
        }

        public void execute(Request request, Context context, Page page) {
            DebugPane debugPane = context.getComponentFactory().createDebugPane();
            page.setDebug(debugPane);
            debugPane.addSection("Specification");
            NakedObject object = context.getMappedObject(request.getObjectId());
            debugPane.appendln(Dump.specification((NakedObject)object));
        }

        public String name() {
            return "spec";
        }
    }

    private class DebugView
    implements Action {
        private DebugView() {
        }

        public void execute(Request request, Context context, Page page) {
            page.setTitle("Debug");
            DebugPane debugPane = context.getComponentFactory().createDebugPane();
            page.setDebug(debugPane);
            DebugString debug = new DebugString();
            AuthenticationSession authenticationSession = NakedObjectsContext.getAuthenticationSession();
            debug.appendTitle("Session");
            if (authenticationSession != null) {
                debug.appendln("user", (Object)authenticationSession.getUserName());
                debug.appendln("roles", (Object)authenticationSession.getRoles());
            } else {
                debug.appendln("none");
            }
            UserProfile userProfile = NakedObjectsContext.getUserProfile();
            debug.appendTitle("User profile");
            if (userProfile != null) {
                userProfile.debugData(debug);
            } else {
                debug.appendln("none");
            }
            debug.appendTitle("Actions");
            Iterator e = WebController.this.actions.entrySet().iterator();
            debug.indent();
            while (e.hasNext()) {
                Map.Entry element = e.next();
                debug.appendln(element.getKey() + " -> " + element.getValue());
            }
            debug.unindent();
            context.debug(debug);
            ImageLookup.debug(debug);
            debugPane.appendln("<pre>" + debug.toString() + "</pre>");
        }

        public String name() {
            return "debug";
        }
    }
}

