/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.html.action.view;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.plugins.html.action.Action;
import org.nakedobjects.plugins.html.action.ActionException;
import org.nakedobjects.plugins.html.action.view.util.MenuUtil;
import org.nakedobjects.plugins.html.component.Page;
import org.nakedobjects.plugins.html.component.ViewPane;
import org.nakedobjects.plugins.html.context.Context;
import org.nakedobjects.plugins.html.request.Request;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public abstract class ObjectViewAbstract
implements Action {
    public final void execute(Request request, Context context, Page page) {
        String idString = request.getObjectId();
        NakedObject adapter = context.getMappedObject(idString);
        if (adapter == null) {
            throw new ActionException("No such object: " + idString);
        }
        NakedObjectsContext.getPersistenceSession().resolveImmediately(adapter);
        page.setTitle(adapter.titleString());
        ViewPane content = page.getViewPane();
        content.setWarningsAndMessages(context.getMessages(), context.getWarnings());
        content.setTitle(adapter.titleString(), adapter.getSpecification().getDescription());
        content.setIconName(adapter.getIconName());
        if (this.addObjectToHistory()) {
            context.addObjectToHistory(idString);
        }
        context.purge();
        content.setMenu(MenuUtil.menu(adapter, idString, context));
        String iconName = adapter.getIconName();
        if (iconName == null) {
            iconName = adapter.getSpecification().getShortName();
        }
        content.setIconName(iconName);
        String field = request.getProperty();
        this.doExecute(context, content, adapter, field);
        context.clearMessagesAndWarnings();
    }

    protected void doExecute(Context context, ViewPane content, NakedObject object, String field) {
    }

    protected boolean addObjectToHistory() {
        return false;
    }
}

