/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.html.action.view.util;

import java.util.ArrayList;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionConstants;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionType;
import org.nakedobjects.plugins.html.component.Component;
import org.nakedobjects.plugins.html.context.Context;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public class MenuUtil {
    public static Component[] menu(NakedObject target, String targetObjectId, Context context) {
        NakedObjectSpecification specification = target.getSpecification();
        NakedObjectAction[] actions1 = specification.getObjectActions(new NakedObjectActionType[]{NakedObjectActionConstants.USER});
        NakedObjectAction[] actions2 = specification.getObjectActions(new NakedObjectActionType[]{NakedObjectActionConstants.EXPLORATION});
        NakedObjectAction[] actions = new NakedObjectAction[actions1.length + actions2.length];
        System.arraycopy(actions1, 0, actions, 0, actions1.length);
        System.arraycopy(actions2, 0, actions, actions1.length, actions2.length);
        Component[] menuItems = MenuUtil.createMenu("Actions", target, actions, context, targetObjectId);
        return menuItems;
    }

    private static Component[] createMenu(String menuName, NakedObject target, NakedObjectAction[] actions, Context context, String targetObjectId) {
        ArrayList<Component> menuItems = new ArrayList<Component>();
        for (int j = 0; j < actions.length; ++j) {
            NakedObjectAction action = actions[j];
            String name = action.getName();
            Component menuItem = null;
            if (action.getActions().length > 0) {
                Component[] components = MenuUtil.createMenu(name, target, action.getActions(), context, targetObjectId);
                menuItem = context.getComponentFactory().createSubmenu(name, components);
            } else {
                boolean isExploring;
                if (!action.isVisible(NakedObjectsContext.getAuthenticationSession(), target).isAllowed() || action.getType() != NakedObjectActionConstants.USER && !(action.getType() == NakedObjectActionConstants.EXPLORATION ? (isExploring = NakedObjectsContext.getDeploymentType().isExploring()) : action.getType() == NakedObjectActionConstants.DEBUG)) continue;
                String actionId = context.mapAction(action);
                boolean collectParameters = action.getParameterCount() == 0 ? false : action.getParameterCount() != 1 || !action.isContributed() || !target.getSpecification().isOfType(action.getParameters()[0].getSpecification());
                Consent consent = action.isUsable(NakedObjectsContext.getAuthenticationSession(), target);
                String consentReason = consent.getReason();
                menuItem = context.getComponentFactory().createMenuItem(actionId, action.getName(), action.getDescription(), consentReason, action.getType(), collectParameters, targetObjectId);
            }
            if (menuItem == null) continue;
            menuItems.add(menuItem);
        }
        return menuItems.toArray(new Component[0]);
    }
}

