/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.html.component.html;

import java.io.PrintWriter;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.html.component.ComponentComposite;
import org.nakedobjects.plugins.html.component.Form;
import org.nakedobjects.plugins.html.component.html.Heading;
import org.nakedobjects.plugins.html.component.html.Html;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public class HtmlForm
extends ComponentComposite
implements Form {
    private final boolean confirm;
    private final boolean hasNext;
    private final boolean hasPrevious;
    private final boolean isEditing;
    private final String id;

    public HtmlForm(String id, String action, int page, int noOfPages, boolean isEditing) {
        this(id, action, page, noOfPages, false, isEditing);
    }

    private HtmlForm(String id, String action, int page, int noOfPages, boolean confirm, boolean isEditing) {
        this.id = id;
        this.confirm = confirm;
        this.isEditing = isEditing;
        this.hasPrevious = page >= 1;
        this.hasNext = page < noOfPages - 1;
    }

    private void addField(String label, String field, String description, boolean readOnly, boolean required, String errorMessage) {
        String error = "";
        if (errorMessage != null) {
            error = "<span class=\"error\"> " + errorMessage + "</span>";
        }
        String optional = "";
        if (!readOnly) {
            optional = !required ? "<span class=\"optional\"> (optional)</span>" : "<span class=\"required\"> *</span>";
        }
        this.add(new Html("<div class=\"field\" title=\"" + description + "\"><span class=\"label\">" + label + "</span><span class=\"separator\">: </span> " + field + optional + error + "</div>"));
    }

    public void addField(NakedObjectSpecification spec, String label, String title, String field, String value, int noLines, boolean wrap, int maxLength, int typicalLength, boolean required, String error) {
        String inputField;
        if (spec.isOfType(NakedObjectsContext.getSpecificationLoader().loadSpecification(Boolean.TYPE)) || spec.isOfType(NakedObjectsContext.getSpecificationLoader().loadSpecification(Boolean.class))) {
            String selected = value != null && value.toLowerCase().equals("true") ? "checked " : "";
            inputField = "<input class=\"value\" type=\"checkbox\" name=\"" + field + "\"" + selected + " value=\"true\"/>";
        } else if (spec.getFullName().endsWith(".Password")) {
            String typicalLengthStr = typicalLength == 0 ? "" : " size=\"" + typicalLength + "\"";
            String maxLengthStr = maxLength == 0 ? "" : " maxlength=\"" + maxLength + "\"";
            inputField = "<input class=\"value\" type=\"password\" name=\"" + field + "\"" + typicalLengthStr + maxLengthStr + "value=\"" + value + "\"/>";
        } else if (noLines > 1) {
            int w = typicalLength > 0 ? typicalLength / noLines : 50;
            inputField = "<textarea class=\"value\" type=\"text\" name=\"" + field + "\" rows=\"" + noLines + "\" cols=\"" + w + "\" wrap=\"" + (wrap ? "hard" : "off") + "\">" + value + "</textarea>";
        } else {
            String typicalLengthStr = typicalLength == 0 ? "" : " size=\"" + typicalLength + "\"";
            String maxLengthStr = maxLength == 0 ? "" : " maxlength=\"" + maxLength + "\"";
            inputField = "<input class=\"value\" type=\"text\" name=\"" + field + "\"" + typicalLengthStr + maxLengthStr + "value=\"" + value + "\"/>";
        }
        this.addField(label, inputField, title, false, required, error);
    }

    public void addFieldName(String fieldLabel) {
        this.add(new Heading(fieldLabel, 4));
    }

    public void addLookup(String fieldLabel, String description, String fieldId, int selectedIndex, String[] instances, String[] ids, boolean required, String errorMessage) {
        StringBuffer testInputField = new StringBuffer();
        testInputField.append("<select class=\"value\" name=\"" + fieldId + "\">");
        if (!required) {
            testInputField.append("<option");
            if (selectedIndex < 0) {
                testInputField.append(" selected");
            }
            testInputField.append(" value=\"");
            testInputField.append("null");
            testInputField.append("\" >[not set]</option>");
        }
        for (int i = 0; i < instances.length; ++i) {
            testInputField.append("<option");
            if (i == selectedIndex) {
                testInputField.append(" selected");
            }
            testInputField.append(" value=\"");
            testInputField.append(ids[i]);
            testInputField.append("\" >");
            testInputField.append(instances[i]);
            testInputField.append("</option>");
        }
        testInputField.append("</select>");
        this.addField(fieldLabel, testInputField.toString(), description, false, required, errorMessage);
    }

    public void addReadOnlyField(String fieldLabel, String title, String description) {
        this.addField(fieldLabel, "<span class=\"value\">" + title + "</span>", description, true, false, null);
    }

    public void write(PrintWriter writer) {
        super.write(writer);
    }

    protected void writeAfter(PrintWriter writer) {
        writer.println("<div class=\"field\">");
        if (this.hasNext) {
            writer.println("<input class=\"action-button\" type=\"submit\" name=\"button\" value=\"Next\"/>");
            if (this.isEditing) {
                writer.println("<input class=\"action-button\" type=\"submit\" name=\"button\" value=\"Save\"/>");
            } else {
                writer.println("<input class=\"action-button\" type=\"submit\" name=\"button\" value=\"Finish\"/>");
            }
        } else if (this.isEditing) {
            writer.println("<input class=\"action-button\" type=\"submit\" name=\"button\" value=\"Save\"/>");
        } else {
            writer.println("<input class=\"action-button\" type=\"submit\" name=\"button\" value=\"Ok\"/>");
        }
        if (this.hasPrevious) {
            writer.println("<input class=\"action-button\" type=\"submit\" name=\"button\" value=\"Previous\"/>");
        }
        writer.println("<input class=\"action-button\" type=\"submit\" name=\"button\" value=\"Cancel\"/>");
        writer.println("</div>");
        writer.println("</form>");
    }

    protected void writeBefore(PrintWriter writer) {
        writer.print("<form name=\"form\" action=\"");
        writer.print("task");
        writer.print(".app");
        writer.print("\" method=\"post\"");
        if (this.confirm) {
            writer.print(" onSubmit=\"return confirm('Are you sure')\"");
        }
        writer.println(">");
        writer.println("<input type=\"hidden\" name=\"id\" value=\"" + this.id + "\"/>");
    }
}

