/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.html.image;

import java.util.HashMap;
import java.util.Map;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.html.image.ImageProvider;

public abstract class ImageProviderAbstract
implements ImageProvider {
    private final String DEFAULT_IMAGE = "Default";
    private final String[] EXTENSIONS = new String[]{"png", "gif", "jpg", "jpeg"};
    private final Map<String, String> images = new HashMap<String, String>();

    public final String image(NakedObject object) {
        if (object == null) {
            return this.image((String)null);
        }
        String iconName = object.getIconName();
        if (iconName != null) {
            return this.image(iconName);
        }
        return this.image(object.getSpecification());
    }

    public final String image(NakedObjectSpecification specification) {
        if (specification == null) {
            return this.image((String)null);
        }
        String specShortName = specification.getShortName();
        String imageName = this.image(specShortName);
        if (imageName != null) {
            return imageName;
        }
        return this.image(specification.superclass());
    }

    public String image(String name) {
        if (name == null) {
            return this.findImage("Default", this.EXTENSIONS);
        }
        String imageName = this.images.get(name);
        if (imageName != null) {
            return imageName;
        }
        imageName = this.findImage(name, this.EXTENSIONS);
        if (imageName != null) {
            this.images.put(name, imageName);
            return imageName;
        }
        return this.image((String)null);
    }

    public final void debug(DebugString debug) {
        debug.appendTitle("Image Lookup");
        debug.indent();
        for (String key : this.images.keySet()) {
            String value = this.images.get(key);
            debug.appendln(key + " -> " + value);
        }
        debug.unindent();
    }

    protected abstract String findImage(String var1, String[] var2);
}

