/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.html.task;

import org.nakedobjects.metamodel.adapter.InvalidEntryException;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.facets.object.parseable.ParseableFacet;
import org.nakedobjects.metamodel.facets.value.PasswordValueFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.SpecificationFacets;
import org.nakedobjects.plugins.html.component.Page;
import org.nakedobjects.plugins.html.context.Context;
import org.nakedobjects.plugins.html.request.Request;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public abstract class Task {
    private static int nextID = 1;
    private int[] boundaries;
    private final String description;
    protected final String[] errors;
    protected String error;
    private final String[] entryText;
    protected final NakedObject[] initialState;
    private final String name;
    protected final String[] names;
    protected final String[] descriptions;
    protected final boolean[] optional;
    protected final boolean[] readOnly;
    protected final int numberOfEntries;
    private int step;
    private final String targetId;
    protected final NakedObjectSpecification[] fieldSpecifications;
    protected final int[] noLines;
    protected final boolean[] wraps;
    protected final int[] maxLength;
    protected final int[] typicalLength;
    protected final int id = nextID++;

    public Task(Context context, String name, String description, NakedObject target, int noFields) {
        this.name = name;
        this.description = description;
        this.targetId = context.mapObject(target);
        this.initialState = new NakedObject[noFields];
        this.names = new String[noFields];
        this.descriptions = new String[noFields];
        this.optional = new boolean[noFields];
        this.readOnly = new boolean[noFields];
        this.fieldSpecifications = new NakedObjectSpecification[noFields];
        this.numberOfEntries = noFields;
        this.entryText = new String[noFields];
        this.errors = new String[noFields];
        this.noLines = new int[noFields];
        this.wraps = new boolean[noFields];
        this.maxLength = new int[noFields];
        this.typicalLength = new int[noFields];
    }

    public void init(Context context) {
        for (int i = 0; i < this.entryText.length; ++i) {
            NakedObject obj = this.initialState[i];
            if (obj == null) {
                this.entryText[i] = "";
                continue;
            }
            if (obj.getSpecification().getFacet(PasswordValueFacet.class) != null) {
                PasswordValueFacet facet = (PasswordValueFacet)obj.getSpecification().getFacet(PasswordValueFacet.class);
                this.entryText[i] = facet.getEditText(obj);
                continue;
            }
            if (obj.getSpecification().isParseable()) {
                this.entryText[i] = obj.titleString();
                continue;
            }
            if (obj.getSpecification().isObject()) {
                if (this.readOnly[i]) {
                    this.entryText[i] = obj.titleString();
                    continue;
                }
                this.entryText[i] = context.mapObject(obj);
                continue;
            }
            if (!obj.getSpecification().isCollection()) continue;
            this.entryText[i] = obj.titleString();
        }
        this.divyUpWork();
    }

    public abstract NakedObject completeTask(Context var1, Page var2);

    private void copyForThisStep(Object[] source, Object[] destination) {
        for (int i = 0; i < this.noOfEntriesInThisStep(); ++i) {
            destination[i] = source[this.firstEntryInThisStep() + i];
        }
    }

    private void copyForThisStep(boolean[] source, boolean[] destination) {
        for (int i = 0; i < this.noOfEntriesInThisStep(); ++i) {
            destination[i] = source[this.firstEntryInThisStep() + i];
        }
    }

    private void copyForThisStep(int[] source, int[] destination) {
        for (int i = 0; i < this.noOfEntriesInThisStep(); ++i) {
            destination[i] = source[this.firstEntryInThisStep() + i];
        }
    }

    public void checkInstances(Context context, NakedObject[] objects) {
    }

    public void debug(DebugString debug) {
        int i;
        debug.indent();
        debug.appendln("name", (Object)this.name);
        debug.appendln("number of steps ", (long)this.numberOfSteps());
        debug.appendln("current step", (long)this.step);
        debug.appendln("target", (Object)this.targetId);
        debug.appendln("steps (" + (this.boundaries.length - 1) + ")");
        debug.indent();
        for (i = 0; i < this.boundaries.length - 1; ++i) {
            debug.appendln("    " + (i + 1) + ". " + this.boundaries[i] + " - " + (this.boundaries[i + 1] - 1));
        }
        debug.unindent();
        debug.appendln("fields (" + this.names.length + ")");
        debug.indent();
        for (i = 0; i < this.names.length; ++i) {
            String status = (this.readOnly[i] ? "R" : "-") + (this.optional[i] ? "O" : "M") + (this.errors[i] == null ? "-" : "E");
            debug.appendln("    " + i + "  " + this.names[i] + " (" + status + "):  " + this.fieldSpecifications[i].getFullName() + " -> " + this.entryText[i]);
        }
        debug.unindent();
        debug.unindent();
    }

    private void divyUpWork() {
        if (this.numberOfEntries == 0) {
            this.boundaries = new int[2];
        } else {
            int[] b = new int[this.numberOfEntries + 2];
            int count = 0;
            b[count++] = 0;
            NakedObjectSpecification type = this.fieldSpecifications[0];
            boolean direct = this.simpleField(type, 0);
            for (int i = 1; i < this.numberOfEntries; ++i) {
                type = this.fieldSpecifications[i];
            }
            b[count++] = this.numberOfEntries;
            this.boundaries = new int[count];
            System.arraycopy(b, 0, this.boundaries, 0, count);
        }
    }

    protected boolean simpleField(NakedObjectSpecification specification, int i) {
        return this.readOnly[i] || specification.isObject() && SpecificationFacets.isBoundedSet((NakedObjectSpecification)specification);
    }

    private int firstEntryInThisStep() {
        return this.boundaries[this.step];
    }

    public String getDescription() {
        return this.description;
    }

    public String getError() {
        return this.error;
    }

    public String[] getErrors() {
        Object[] array = new String[this.noOfEntriesInThisStep()];
        this.copyForThisStep(this.errors, array);
        return array;
    }

    public String[] getFieldDescriptions() {
        Object[] array = new String[this.noOfEntriesInThisStep()];
        this.copyForThisStep(this.descriptions, array);
        return array;
    }

    public String[] getEntryText() {
        Object[] array = new String[this.noOfEntriesInThisStep()];
        this.copyForThisStep(this.entryText, array);
        return array;
    }

    public String getName() {
        return this.name;
    }

    public String[] getNames() {
        Object[] array = new String[this.noOfEntriesInThisStep()];
        this.copyForThisStep(this.names, array);
        return array;
    }

    public NakedObject[][] getOptions(Context context) {
        return this.getOptions(context, this.firstEntryInThisStep(), this.noOfEntriesInThisStep());
    }

    protected NakedObject[][] getOptions(Context context, int from, int len) {
        return new NakedObject[len][];
    }

    protected NakedObject[] getEntries(Context context) {
        NakedObject[] entries = new NakedObject[this.entryText.length];
        for (int i = 0; i < entries.length; ++i) {
            if (this.entryText == null || this.readOnly[i]) continue;
            NakedObjectSpecification fieldSpecification = this.fieldSpecifications[i];
            if (fieldSpecification.isParseable()) {
                ParseableFacet parser = (ParseableFacet)fieldSpecification.getFacet(ParseableFacet.class);
                try {
                    entries[i] = parser.parseTextEntry(this.initialState[i], this.entryText[i]);
                }
                catch (InvalidEntryException e) {
                    this.errors[i] = e.getMessage();
                }
                catch (TextEntryParseException e) {
                    this.errors[i] = e.getMessage();
                }
                continue;
            }
            if (!fieldSpecification.isObject() || this.entryText[i] == null) continue;
            entries[i] = this.entryText[i].equals("null") ? null : context.getMappedObject(this.entryText[i]);
        }
        return entries;
    }

    public String getId() {
        return "" + this.id;
    }

    public boolean[] getOptional() {
        boolean[] array = new boolean[this.noOfEntriesInThisStep()];
        this.copyForThisStep(this.optional, array);
        return array;
    }

    public int[] getNoLines() {
        int[] array = new int[this.noOfEntriesInThisStep()];
        this.copyForThisStep(this.noLines, array);
        return array;
    }

    public boolean[] getWraps() {
        boolean[] array = new boolean[this.noOfEntriesInThisStep()];
        this.copyForThisStep(this.wraps, array);
        return array;
    }

    public int[] getMaxLength() {
        int[] array = new int[this.noOfEntriesInThisStep()];
        this.copyForThisStep(this.maxLength, array);
        return array;
    }

    public int[] getTypicalLength() {
        int[] array = new int[this.noOfEntriesInThisStep()];
        this.copyForThisStep(this.typicalLength, array);
        return array;
    }

    public boolean[] getReadOnly() {
        boolean[] array = new boolean[this.noOfEntriesInThisStep()];
        this.copyForThisStep(this.readOnly, array);
        return array;
    }

    public int getStep() {
        return this.step;
    }

    public NakedObject getTarget(Context context) {
        return context.getMappedObject(this.targetId);
    }

    public String[] getTrail() {
        String[] trail = new String[this.boundaries.length - 1];
        for (int i = 0; i < trail.length; ++i) {
            trail[i] = "step " + i;
        }
        return trail;
    }

    public NakedObjectSpecification[] getTypes() {
        Object[] array = new NakedObjectSpecification[this.noOfEntriesInThisStep()];
        this.copyForThisStep(this.fieldSpecifications, array);
        return array;
    }

    public boolean isEditing() {
        return false;
    }

    public void nextStep() {
        ++this.step;
    }

    private int noOfEntriesInThisStep() {
        return this.boundaries[this.step + 1] - this.boundaries[this.step];
    }

    public int numberOfSteps() {
        return this.boundaries.length - 1;
    }

    public void previousStep() {
        --this.step;
    }

    public void setFromFields(Request request, Context context) {
        int fldNo = 0;
        for (int i = this.boundaries[this.step]; i < this.boundaries[this.step + 1]; ++i) {
            String textEntry = request.getFieldEntry(fldNo++);
            if (this.readOnly[i]) continue;
            NakedObjectSpecification spec = this.fieldSpecifications[i];
            if (!(!spec.isOfType(NakedObjectsContext.getSpecificationLoader().loadSpecification(Boolean.TYPE)) && !spec.isOfType(NakedObjectsContext.getSpecificationLoader().loadSpecification(Boolean.class)) || textEntry != null && textEntry.equals("true"))) {
                textEntry = "false";
            }
            this.entryText[i] = textEntry;
            try {
                this.errors[i] = null;
                this.setFromField(context, i, spec, textEntry);
                if (this.optional[i] || textEntry != null && !textEntry.equals("")) continue;
                this.errors[i] = "Field required";
                continue;
            }
            catch (InvalidEntryException e) {
                this.errors[i] = e.getMessage();
                continue;
            }
            catch (TextEntryParseException e) {
                this.errors[i] = e.getMessage();
            }
        }
    }

    private void setFromField(Context context, int i, NakedObjectSpecification spec, String textEntry) {
        if (spec.isParseable()) {
            if (textEntry == null) {
                return;
            }
            NakedObject nakedValue = this.initialState[i];
            ParseableFacet parser = (ParseableFacet)spec.getFacet(ParseableFacet.class);
            parser.parseTextEntry(nakedValue, textEntry);
        }
    }

    public abstract void checkForValidity(Context var1);
}

