/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.html.task;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.html.action.Action;
import org.nakedobjects.plugins.html.action.ActionException;
import org.nakedobjects.plugins.html.component.Component;
import org.nakedobjects.plugins.html.component.Form;
import org.nakedobjects.plugins.html.component.Page;
import org.nakedobjects.plugins.html.component.ViewPane;
import org.nakedobjects.plugins.html.context.Context;
import org.nakedobjects.plugins.html.request.Request;
import org.nakedobjects.plugins.html.task.InvokeMethod;
import org.nakedobjects.plugins.html.task.Task;
import org.nakedobjects.plugins.html.task.TaskLookupException;

public final class TaskStep
implements Action {
    private void addSelector(Context context, Form form, String currentEntry, String fieldId, String fieldLabel, String fieldDescription, boolean required, String errorMessage, Task task, NakedObject[] objects) {
        task.checkInstances(context, objects);
        int size = 0;
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] == null) continue;
            ++size;
        }
        String[] instances = new String[size];
        String[] ids = new String[size];
        int selectedIndex = -1;
        int j = 0;
        for (int i = 0; i < objects.length; ++i) {
            NakedObject element = objects[i];
            if (element == null) continue;
            instances[j] = element.titleString();
            ids[j] = context.mapObject(element);
            if (ids[j].equals(currentEntry)) {
                selectedIndex = i;
            }
            ++j;
        }
        form.addLookup(fieldLabel, fieldDescription, fieldId, selectedIndex, instances, ids, required, errorMessage);
    }

    private void addSelectorForKnownReferences(Context context, Form form, NakedObjectSpecification type, String currentEntry, String fieldId, String fieldLabel, String fieldDescription, boolean required, String errorMessage, Task task) {
        NakedObject[] objects = context.getKnownInstances(type);
        this.addSelector(context, form, currentEntry, fieldId, fieldLabel, fieldDescription, required, errorMessage, task, objects);
    }

    private void addSelectorForObjectOptions(Context context, Form form, String currentEntry, String fieldId, String fieldLabel, String fieldDescription, NakedObject[] options, boolean required, String errorMessage, Task task) {
        NakedObject[] objects = new NakedObject[options.length];
        for (int i = 0; i < options.length; ++i) {
            objects[i] = options[i];
        }
        this.addSelector(context, form, currentEntry, fieldId, fieldLabel, fieldDescription, required, errorMessage, task, objects);
    }

    private void addSelectorForValueOptions(Form form, String currentEntry, String fieldId, String fieldLabel, String fieldDescription, NakedObject[] options, boolean required, String errorMessage, Task task) {
        int selectedIndex = -1;
        String[] instances = new String[options.length];
        for (int i = 0; i < options.length; ++i) {
            instances[i] = options[i].titleString();
            if (!currentEntry.equals(instances[i])) continue;
            selectedIndex = i;
        }
        form.addLookup(fieldLabel, fieldDescription, fieldId, selectedIndex, instances, instances, required, errorMessage);
    }

    private void addTextFieldForParseable(Form form, NakedObjectSpecification type, String currentEntryText, String fieldId, String fieldLabel, String fieldDescription, int noLines, boolean wrap, int maxLength, int typicalLength, boolean required, String errorMessage) {
        form.addField(type, fieldLabel, fieldDescription, fieldId, currentEntryText, noLines, wrap, maxLength, typicalLength, required, errorMessage);
    }

    private void displayTask(Context context, Page page, Task task) {
        page.setTitle(task.getName());
        ViewPane content = page.getViewPane();
        NakedObject targetAdapter = task.getTarget(context);
        String titleString = targetAdapter.titleString();
        if (targetAdapter.isTransient()) {
            titleString = titleString + " (Unsaved)";
        }
        content.setTitle(titleString, targetAdapter.getSpecification().getDescription());
        String iconName = targetAdapter.getIconName();
        if (iconName == null) {
            iconName = targetAdapter.getSpecification().getShortName();
        }
        content.setIconName(iconName);
        StringBuffer crumbs = new StringBuffer();
        String[] trail = task.getTrail();
        for (int i = 0; i < trail.length; ++i) {
            crumbs.append(" : ");
            crumbs.append(trail[i]);
        }
        Component[] action = new Component[]{context.getComponentFactory().createInlineBlock("name", task.getName(), task.getDescription())};
        content.setMenu(action);
        if (task.getError() != null) {
            content.add(context.getComponentFactory().createInlineBlock("error", task.getError(), null));
        }
        Form form = context.getComponentFactory().createForm(task.getId(), this.name(), task.getStep(), task.numberOfSteps(), task.isEditing());
        String[] parameterLabels = task.getNames();
        String[] parameterDescriptions = task.getFieldDescriptions();
        String[] errors = task.getErrors();
        String[] entryText = task.getEntryText();
        int[] noLines = task.getNoLines();
        boolean[] canWrap = task.getWraps();
        int[] maxLength = task.getMaxLength();
        int[] typicalLength = task.getTypicalLength();
        NakedObject[][] options = task.getOptions(context);
        boolean[] optional = task.getOptional();
        boolean[] readOnly = task.getReadOnly();
        NakedObjectSpecification[] types = task.getTypes();
        for (int i = 0; i < parameterLabels.length; ++i) {
            NakedObjectSpecification paramSpec = types[i];
            String fieldId = "fld" + i;
            String fieldLabel = parameterLabels[i] == null ? "" : parameterLabels[i];
            String fieldDescription = parameterDescriptions[i] == null ? "" : parameterDescriptions[i];
            String currentEntryTitle = entryText[i];
            String error = errors[i];
            if (readOnly[i]) {
                this.addReadOnlyField(form, fieldLabel, currentEntryTitle, fieldDescription);
                continue;
            }
            if (paramSpec.isParseable() && options[i] != null && options[i].length > 0) {
                this.addSelectorForValueOptions(form, currentEntryTitle, fieldId, fieldLabel, fieldDescription, options[i], !optional[i], error, task);
                continue;
            }
            if (paramSpec.isParseable()) {
                this.addTextFieldForParseable(form, paramSpec, currentEntryTitle, fieldId, fieldLabel, fieldDescription, noLines[i], canWrap[i], maxLength[i], typicalLength[i], !optional[i], error);
                continue;
            }
            if (paramSpec.isObject() && options[i] != null && options[i].length > 0) {
                this.addSelectorForObjectOptions(context, form, currentEntryTitle, fieldId, fieldLabel, fieldDescription, options[i], !optional[i], error, task);
                continue;
            }
            if (paramSpec.isObject()) {
                this.addSelectorForKnownReferences(context, form, paramSpec, currentEntryTitle, fieldId, fieldLabel, fieldDescription, !optional[i], error, task);
                continue;
            }
            throw new NakedObjectException();
        }
        content.add(form);
    }

    private void addReadOnlyField(Form form, String fieldLabel, String title, String description) {
        form.addReadOnlyField(fieldLabel, title, description);
    }

    public void execute(Request request, Context context, Page page) {
        String taskId = request.getTaskId();
        Task task = context.getTask(taskId);
        String button = request.getButtonName();
        if (task == null && !"Cancel".equals(button)) {
            throw new TaskLookupException("No task found with id " + taskId);
        }
        if (button == null) {
            this.displayTask(context, page, task);
        } else if ("Cancel".equals(button)) {
            this.forwardCancel(request, context, task);
        } else if ("Previous".equals(button)) {
            task.setFromFields(request, context);
            task.previousStep();
            this.displayTask(context, page, task);
        } else if ("Next".equals(button)) {
            task.setFromFields(request, context);
            task.nextStep();
            this.displayTask(context, page, task);
        } else if ("Finish".equals(button) || "Save".equals(button) || "Ok".equals(button)) {
            task.setFromFields(request, context);
            task.checkForValidity(context);
            if (this.hasErrors(task)) {
                this.displayTask(context, page, task);
            } else {
                String targetId = context.mapObject(task.getTarget(context));
                NakedObject result = task.completeTask(context, page);
                if (result instanceof NakedObject) {
                    NakedObject object = result;
                    context.updateVersion(object);
                }
                InvokeMethod.displayMethodResult(request, context, page, result, targetId);
                context.endTask(task);
            }
        } else {
            throw new ActionException("No task action: " + button);
        }
    }

    private void forwardCancel(Request request, Context context, Task task) {
        Request cancelTask = context.cancelTask(task);
        request.forward(cancelTask);
    }

    private boolean hasErrors(Task task) {
        if (task.getError() != null) {
            return true;
        }
        String[] errors = task.getErrors();
        for (int i = 0; i < errors.length; ++i) {
            if (errors[i] == null) continue;
            return true;
        }
        return false;
    }

    public String name() {
        return "task";
    }
}

