/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.html.component.html;

import java.io.PrintWriter;
import java.util.StringTokenizer;
import org.nakedobjects.plugins.html.component.Block;
import org.nakedobjects.plugins.html.component.Component;
import org.nakedobjects.plugins.html.component.Page;
import org.nakedobjects.plugins.html.component.html.Div;

public abstract class AbstractHtmlPage
implements Component,
Page {
    private final StringBuffer debug = new StringBuffer();
    private final Block pageHeader = new Div(null, "page-header");
    private final String siteFooter;
    private final String siteHeader;
    private final String styleSheet;
    private String title = "Naked Objects";

    public AbstractHtmlPage(String styleSheet, String header, String footer) {
        this.styleSheet = styleSheet == null ? "default.css" : styleSheet;
        this.siteHeader = header;
        this.siteFooter = footer;
    }

    public void addDebug(String html) {
        this.debug.append("<div class=\"detail\">");
        this.debug.append(html);
        this.debug.append("</div>");
    }

    public void addDebug(String name, String value) {
        this.debug.append("<div class=\"detail\">");
        this.debug.append("<span class=\"label\">");
        this.debug.append(name);
        this.debug.append("</span>: ");
        this.debug.append(value);
        this.debug.append("</div>");
    }

    public Block getPageHeader() {
        return this.pageHeader;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void write(PrintWriter writer) {
        writer.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
        writer.println("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">");
        writer.println("  <head>");
        writer.print("  <title>");
        writer.print(this.title);
        writer.println("</title>");
        writer.println("  <meta name=\"description\" content=\"Naked Objects Application Web Page\" />");
        StringTokenizer st = new StringTokenizer(this.styleSheet, ",");
        int i = 0;
        while (st.hasMoreTokens()) {
            String style = st.nextToken().trim();
            writer.print("  <link rel=\"");
            if (i++ > 0) {
                writer.print("alternate ");
            }
            writer.print("stylesheet\" title=\"Style " + i + "\" href=\"./");
            writer.print(style);
            writer.println("\" type=\"text/css\" media=\"all\"/>");
        }
        writer.println("  </head>");
        writer.println("  <body onLoad=\"window.document.form.fld0.focus()\">");
        if (this.siteHeader != null) {
            writer.println("  <!-- the following block is added externally via configuration -->");
            writer.println(this.siteHeader);
        }
        this.writeContent(writer);
        if (this.siteFooter != null) {
            writer.println("  <!-- the following block is added externally via configuration -->");
            writer.println(this.siteFooter);
        }
        if (this.debug.length() > 0) {
            writer.println("<div id=\"debug\">");
            writer.println("<h4>Debug</h4>");
            writer.println(this.debug);
            writer.println("</div>");
        }
        writer.println("  </body>");
        writer.println("</html>");
    }

    protected abstract void writeContent(PrintWriter var1);
}

