/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.html.component.html;

import java.io.PrintWriter;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.html.component.ComponentAbstract;
import org.nakedobjects.plugins.html.image.ImageLookup;

class CollectionLink
extends ComponentAbstract {
    private final String objectId;
    private final String fieldId;
    private final NakedObjectSpecification specification;
    private final String title;
    private final String description;

    public CollectionLink(NakedObjectAssociation field, NakedObject collection, String description, String objectId) {
        this.description = description;
        this.objectId = objectId;
        this.fieldId = field.getId();
        this.title = collection.titleString();
        this.specification = field.getSpecification();
    }

    public void write(PrintWriter writer) {
        writer.print("<span class=\"value\"");
        if (this.description != null) {
            writer.print(" title=\"");
            writer.print(this.description);
            writer.print("\"");
        }
        writer.print(">");
        writer.print("<a href=\"");
        writer.print("fieldCollection.app?id=");
        writer.print(this.objectId);
        writer.print("&amp;field=");
        writer.print(this.fieldId);
        writer.print("\"");
        writer.print("><img src=\"");
        writer.print(ImageLookup.image(this.specification));
        writer.print("\" alt=\"icon\">");
        writer.print(this.title);
        writer.print("</a>");
        writer.println("</span>");
    }
}

