/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.html.component.html;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.propparam.multiline.MultiLineFacet;
import org.nakedobjects.metamodel.facets.value.BooleanValueFacet;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionType;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.html.component.Block;
import org.nakedobjects.plugins.html.component.Component;
import org.nakedobjects.plugins.html.component.ComponentFactory;
import org.nakedobjects.plugins.html.component.DebugPane;
import org.nakedobjects.plugins.html.component.Form;
import org.nakedobjects.plugins.html.component.Page;
import org.nakedobjects.plugins.html.component.Table;
import org.nakedobjects.plugins.html.component.html.ActionComponent;
import org.nakedobjects.plugins.html.component.html.BreadCrumbs;
import org.nakedobjects.plugins.html.component.html.Checkbox;
import org.nakedobjects.plugins.html.component.html.CollectionIcon;
import org.nakedobjects.plugins.html.component.html.CollectionLink;
import org.nakedobjects.plugins.html.component.html.Div;
import org.nakedobjects.plugins.html.component.html.DynamicHtmlPage;
import org.nakedobjects.plugins.html.component.html.ErrorMessage;
import org.nakedobjects.plugins.html.component.html.Heading;
import org.nakedobjects.plugins.html.component.html.HtmlDebug;
import org.nakedobjects.plugins.html.component.html.HtmlForm;
import org.nakedobjects.plugins.html.component.html.HtmlTable;
import org.nakedobjects.plugins.html.component.html.Link;
import org.nakedobjects.plugins.html.component.html.LogonFormPage;
import org.nakedobjects.plugins.html.component.html.MenuItem;
import org.nakedobjects.plugins.html.component.html.ObjectIcon;
import org.nakedobjects.plugins.html.component.html.ServiceComponent;
import org.nakedobjects.plugins.html.component.html.Span;
import org.nakedobjects.plugins.html.component.html.Submenu;
import org.nakedobjects.plugins.html.component.html.UserSwapLink;
import org.nakedobjects.plugins.html.component.html.WebViewerException;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public class HtmlComponentFactory
implements ComponentFactory {
    private final String footer;
    private final String header;
    private final String styleSheet;

    public HtmlComponentFactory() {
        NakedObjectConfiguration configuration = NakedObjectsContext.getConfiguration();
        this.styleSheet = configuration.getString("nakedobjects.viewer.html.style-sheet");
        String file = configuration.getString("nakedobjects.viewer.html.header-file");
        this.header = file == null ? configuration.getString("nakedobjects.viewer.html.header") : this.loadFile(file);
        file = configuration.getString("nakedobjects.viewer.html.footer-file");
        this.footer = file == null ? configuration.getString("nakedobjects.viewer.html.footer") : this.loadFile(file);
    }

    public Block createBlock(String style, String description) {
        return new Div(style, description);
    }

    public Component createBreadCrumbs(String[] names, boolean[] isLinked) {
        return new BreadCrumbs(names, isLinked);
    }

    public Component createCollectionIcon(NakedObjectAssociation field, NakedObject collection, String id) {
        return new CollectionLink(field, collection, field.getDescription(), id);
    }

    public DebugPane createDebugPane() {
        return new HtmlDebug();
    }

    public Component createEditOption(String id) {
        return new ActionComponent("edit", "Edit Object", "Edit the current object", id, null, null);
    }

    public Component createRemoveOption(String id, String elementId, String fieldName) {
        return new ActionComponent("remove", "Remove", "Remove item from collection", id, elementId, fieldName);
    }

    public Component createAddOption(String id, String fieldName) {
        return new ActionComponent("add", "Add Item", "Add item to collection", id, null, fieldName);
    }

    public Component createErrorMessage(Exception e, boolean isDebug) {
        return new ErrorMessage(e, isDebug);
    }

    public Form createForm(String id, String actionName, int step, int noOfPages, boolean isEditing) {
        return new HtmlForm(id, actionName, step, noOfPages, isEditing);
    }

    public Component createHeading(String name) {
        return new Heading(name, 4);
    }

    public Component createInlineBlock(String style, String text, String description) {
        return new Span(style, text, description);
    }

    public Component createCheckboxBlock(boolean isEditable, boolean isSet) {
        return new Checkbox(isSet, isEditable);
    }

    public Component createSubmenu(String menuName, Component[] items) {
        return new Submenu(menuName, items);
    }

    public Component createLink(String link, String name, String description) {
        return new Link(link, name, description);
    }

    public Component createMenuItem(String actionId, String name, String description, String reasonDisabled, NakedObjectActionType type, boolean hasParameters, String targetObjectId) {
        return new MenuItem(actionId, name, description, reasonDisabled, type, hasParameters, targetObjectId);
    }

    public Component createCollectionIcon(NakedObject collection, String collectionId) {
        return new CollectionIcon(collection, collection.getSpecification().getDescription(), collectionId);
    }

    public Component createObjectIcon(NakedObject object, String objectId, String style) {
        return new ObjectIcon(object, object.getSpecification().getDescription(), objectId, style);
    }

    public Component createObjectIcon(NakedObjectAssociation field, NakedObject object, String objectId, String style) {
        return new ObjectIcon(object, field.getDescription(), objectId, style);
    }

    public Page createPage() {
        return new DynamicHtmlPage(this.styleSheet, this.header, this.footer);
    }

    public LogonFormPage createLogonPage(String user, String password) {
        return new LogonFormPage(this.styleSheet, this.header, this.footer, user, password);
    }

    public Component createService(String objectId, String title, String iconName) {
        return new ServiceComponent(objectId, title, iconName);
    }

    public Table createTable(int noColumns, boolean withSelectorColumn) {
        return new HtmlTable(noColumns, withSelectorColumn);
    }

    public Component createUserSwap(String name) {
        return new UserSwapLink(name);
    }

    public Component createParseableField(NakedObjectAssociation field, NakedObject value, boolean isEditable) {
        boolean isWrapped;
        BooleanValueFacet facet = (BooleanValueFacet)field.getSpecification().getFacet(BooleanValueFacet.class);
        if (facet != null) {
            return this.createCheckboxBlock(isEditable, facet.isSet(value));
        }
        String titleString = value != null ? value.titleString() : "";
        MultiLineFacet multiLineFacet = (MultiLineFacet)field.getSpecification().getFacet(MultiLineFacet.class);
        boolean bl = isWrapped = multiLineFacet != null && !multiLineFacet.preventWrapping();
        if (isWrapped) {
            return this.createInlineBlock("value", "<pre>" + titleString + "</pre>", null);
        }
        return this.createInlineBlock("value", titleString, null);
    }

    private String loadFile(String file) {
        StringBuffer content = new StringBuffer();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((line = reader.readLine()) != null) {
                content.append(line);
                content.append("\n");
            }
        }
        catch (FileNotFoundException e) {
            throw new WebViewerException("Failed to find file " + file);
        }
        catch (IOException e) {
            throw new WebViewerException("Failed to load file " + file, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignore) {}
            }
        }
        return content.toString();
    }
}

