/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.html.component.html;

import java.io.PrintWriter;
import org.nakedobjects.plugins.html.component.Component;
import org.nakedobjects.plugins.html.component.ComponentComposite;
import org.nakedobjects.plugins.html.component.Table;
import org.nakedobjects.plugins.html.component.html.HtmlException;
import org.nakedobjects.plugins.html.component.html.Row;
import org.nakedobjects.plugins.html.component.html.Span;
import org.nakedobjects.plugins.html.component.html.TableHeader;

public class HtmlTable
extends ComponentComposite
implements Table {
    private String summary;
    private final TableHeader header;
    private final int noColumns;
    private Row row;
    private int cellCount;
    private final boolean addSelector;

    public HtmlTable(int noColumns, boolean withSelectorColumn) {
        this.noColumns = noColumns + (withSelectorColumn ? 1 : 0);
        this.addSelector = withSelectorColumn;
        this.header = new TableHeader();
    }

    public Row newRow() {
        Row row = new Row();
        this.add(row);
        return row;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void write(PrintWriter writer) {
        writer.print("<table summary=\"" + this.summary + "\">");
        writer.print("<tr><th></th>");
        this.header.write(writer);
        writer.println("</tr>");
        super.write(writer);
        writer.println("</table>");
    }

    protected void write(PrintWriter writer, Component component) {
        writer.print("<tr>");
        component.write(writer);
        if (this.addSelector) {
            writer.print("<td><input type=\"checkbox\" value=\"selected\"/></td>");
        }
        writer.println("</tr>");
    }

    public void addCell(String value, boolean truncate) {
        this.row.addCell(value, truncate);
        ++this.cellCount;
        if (this.cellCount > this.noColumns) {
            throw new HtmlException("Too many cells added: " + this.cellCount);
        }
    }

    public void addEmptyCell() {
        this.addCell(new Span("empty-cell", "", null));
    }

    public void addCell(Component component) {
        this.row.add(component);
        ++this.cellCount;
        if (this.cellCount > this.noColumns) {
            throw new HtmlException("Too many cells added: " + this.cellCount);
        }
    }

    public void addColumnHeader(String name) {
        this.header.addHeader(name);
        ++this.cellCount;
        if (this.cellCount > this.noColumns) {
            throw new HtmlException("Too many cells added: " + this.cellCount);
        }
    }

    public void addRowHeader(Component component) {
        this.row = new Row();
        this.add(this.row);
        this.cellCount = 0;
        this.row.addCell(component);
    }
}

