/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.html.context;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.plugins.html.component.Block;
import org.nakedobjects.plugins.html.component.ComponentFactory;
import org.nakedobjects.plugins.html.context.CollectionMapping;
import org.nakedobjects.plugins.html.context.HistoryEntry;
import org.nakedobjects.plugins.html.context.ObjectHistory;
import org.nakedobjects.plugins.html.context.ObjectLookupException;
import org.nakedobjects.plugins.html.context.ObjectMapping;
import org.nakedobjects.plugins.html.context.PersistentObjectMapping;
import org.nakedobjects.plugins.html.context.TransientObjectMapping;
import org.nakedobjects.plugins.html.crumb.CollectionCrumb;
import org.nakedobjects.plugins.html.crumb.Crumb;
import org.nakedobjects.plugins.html.crumb.ObjectCrumb;
import org.nakedobjects.plugins.html.crumb.ObjectFieldCrumb;
import org.nakedobjects.plugins.html.crumb.TaskCrumb;
import org.nakedobjects.plugins.html.request.Request;
import org.nakedobjects.plugins.html.task.Task;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.ConcurrencyException;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;
import org.nakedobjects.runtime.userprofile.UserProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context {
    private static final Logger LOG = Logger.getLogger(Context.class);
    private final Map actionMap = new HashMap();
    private final ComponentFactory componentFactory;
    private final ObjectHistory history = new ObjectHistory();
    private boolean isValid;
    private int max;
    private final Map<String, CollectionMapping> collectionMap = new HashMap<String, CollectionMapping>();
    private final Map<String, ObjectMapping> objectMap = new HashMap<String, ObjectMapping>();
    private final Map<String, ObjectMapping> serviceMap = new HashMap<String, ObjectMapping>();
    private final Stack<Crumb> crumbs = new Stack();
    private final List<String> messages = new ArrayList<String>();
    private final List<String> warnings = new ArrayList<String>();
    private AuthenticationSession session;

    public Context(ComponentFactory factory) {
        this.componentFactory = factory;
        this.isValid = true;
        this.clearMessagesAndWarnings();
        LOG.debug((Object)(this + " created with " + factory));
    }

    public void setObjectCrumb(NakedObject object) {
        while (this.crumbs.size() > 0 && !(this.crumbs.lastElement() instanceof TaskCrumb)) {
            this.crumbs.pop();
        }
        String id = this.mapObject(object);
        this.crumbs.push(new ObjectCrumb(id, object));
    }

    public void addCollectionFieldCrumb(String collectionFieldName) {
        this.crumbs.push(new ObjectFieldCrumb(collectionFieldName));
    }

    public void addCollectionCrumb(String id) {
        while (this.crumbs.size() > 0 && !(this.crumbs.lastElement() instanceof TaskCrumb)) {
            this.crumbs.pop();
        }
        this.crumbs.push(new CollectionCrumb(id, this.getMappedCollection(id)));
    }

    public void addTaskCrumb(Task task) {
        while (this.crumbs.size() > 1 && !(this.crumbs.lastElement() instanceof ObjectCrumb)) {
            this.crumbs.pop();
        }
        Assert.assertNotNull((Object)task);
        Assert.assertTrue((!this.isTask() ? 1 : 0) != 0);
        task.init(this);
        this.crumbs.push(new TaskCrumb(task));
    }

    public void debug(DebugString debug) {
        debug.startSection("Web Session Context");
        debug.appendAsHexln("hash", (long)this.hashCode());
        debug.appendln("session", (Object)this.session);
        debug.appendln("is valid", this.isValid);
        debug.appendln("next id", (long)this.max);
        debug.appendln("factory", (Object)this.componentFactory);
        debug.appendln("is task", this.isTask());
        debug.appendln("crumbs (" + this.crumbs.size() + ")");
        debug.indent();
        for (int i = 0; i < this.crumbs.size(); ++i) {
            Crumb crumb = (Crumb)this.crumbs.get(i);
            debug.appendln(i + 1 + ". " + crumb);
            debug.indent();
            crumb.debug(debug);
            debug.unindent();
        }
        debug.unindent();
        debug.startSection("Objects");
        for (String id : this.objectMap.keySet()) {
            ObjectMapping object = this.objectMap.get(id);
            debug.appendln(id + " -> " + object.getOid());
            debug.indent();
            object.debug(debug);
            debug.unindent();
        }
        debug.endSection();
        debug.startSection("Collections");
        for (String id : this.collectionMap.keySet()) {
            CollectionMapping coll = this.collectionMap.get(id);
            debug.appendln(id + " -> collection of " + coll.getElementSpecification().getPluralName());
            coll.debug(debug);
        }
        debug.endSection();
        debug.startSection("Actions");
        this.debugMap(debug, this.actionMap);
        debug.endSection();
        debug.startSection("History");
        this.history.debug(debug);
        debug.endSection();
        debug.endSection();
    }

    private void debugMap(DebugString debug, Map map) {
        for (String name : map.keySet()) {
            debug.appendln(name + " -> " + map.get(name));
        }
    }

    public NakedObjectAction getMappedAction(String id) {
        return (NakedObjectAction)this.getMappedInstance(this.actionMap, id);
    }

    public ComponentFactory getComponentFactory() {
        return this.componentFactory;
    }

    public NakedObject[] getKnownInstances(NakedObjectSpecification type) {
        ArrayList<NakedObject> instances = new ArrayList<NakedObject>();
        for (String id : this.objectMap.keySet()) {
            NakedObject adapter = this.getMappedObject(id);
            NakedObjectsContext.getPersistenceSession().resolveImmediately(adapter);
            if (!adapter.getSpecification().isOfType(type)) continue;
            instances.add(adapter);
        }
        NakedObject[] array = new NakedObject[instances.size()];
        instances.toArray(array);
        return array;
    }

    private String addToMap(Map map, Object object) {
        Assert.assertNotNull((Object)object);
        if (map.containsValue(object)) {
            return this.findExistingId(map, object);
        }
        return this.mapNewObject(map, object);
    }

    private String mapNewObject(Map map, Object object) {
        ++this.max;
        String id = "" + this.max;
        map.put(id, object);
        String mapName = map == this.objectMap ? "object" : (map == this.collectionMap ? "collection" : "action");
        LOG.debug((Object)("add " + object + " to " + mapName + " as #" + id));
        return id;
    }

    private String findExistingId(Map<String, ?> map, Object object) {
        for (String id : map.keySet()) {
            if (!object.equals(map.get(id))) continue;
            return id;
        }
        throw new NakedObjectException();
    }

    private Object getMappedInstance(Map map, String id) {
        Object object = map.get(id);
        if (object == null) {
            String mapName = map == this.objectMap ? "object" : (map == this.collectionMap ? "collection" : "action");
            throw new ObjectLookupException("No object in " + mapName + " map with id " + id);
        }
        return object;
    }

    public NakedObject getMappedCollection(String id) {
        CollectionMapping map = (CollectionMapping)this.getMappedInstance(this.collectionMap, id);
        return map.getCollection(this);
    }

    public NakedObject getMappedObject(String id) {
        ObjectMapping mappedObject = (ObjectMapping)this.getMappedInstance(this.objectMap, id);
        NakedObject object = mappedObject.getObject();
        if (object.isPersistent() && object.getResolveState().isGhost()) {
            NakedObjectsContext.getPersistenceSession().resolveImmediately(object);
        }
        try {
            mappedObject.checkVersion(object);
        }
        catch (ConcurrencyException e) {
            LOG.info((Object)("concurrency conflict: " + e.getMessage()));
            this.messages.clear();
            this.messages.add(e.getMessage());
            this.messages.add("Reloaded object " + object.titleString());
            this.updateVersion(object);
        }
        return object;
    }

    public Task getTask(String taskId) {
        Task task = null;
        for (int i = this.crumbs.size() - 1; i >= 0; --i) {
            TaskCrumb taskCrumb;
            String id;
            Object crumb = this.crumbs.get(i);
            if (!(crumb instanceof TaskCrumb) || !taskId.equals(id = (taskCrumb = (TaskCrumb)crumb).getTask().getId())) continue;
            task = taskCrumb.getTask();
            break;
        }
        return task;
    }

    public Request cancelTask(Task task) {
        if (task != null) {
            this.endTask(task);
        }
        Crumb crumb = (Crumb)this.crumbs.get(this.crumbs.size() - 1);
        return crumb.changeContext();
    }

    public void invalidate() {
        this.isValid = false;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isLoggedIn() {
        return this.session != null;
    }

    public String mapAction(NakedObjectAction action) {
        return this.addToMap(this.actionMap, action);
    }

    public String mapObject(NakedObject adapter) {
        ObjectMapping mapping = this.objectMapping(adapter);
        return this.addToMap(this.objectMap, mapping);
    }

    private ObjectMapping objectMapping(NakedObject adapter) {
        ObjectMapping mapping = adapter.isTransient() ? new TransientObjectMapping(adapter) : new PersistentObjectMapping(adapter);
        return mapping;
    }

    public String mapCollection(NakedObject collection) {
        CollectionMapping map = new CollectionMapping(this, collection);
        return this.addToMap(this.collectionMap, map);
    }

    public void endTask(Task task) {
        for (int i = this.crumbs.size() - 1; i >= 0; --i) {
            TaskCrumb taskCrumb;
            Object crumb = this.crumbs.get(i);
            if (!(crumb instanceof TaskCrumb) || (taskCrumb = (TaskCrumb)crumb).getTask() != task) continue;
            this.crumbs.remove(taskCrumb);
            return;
        }
        throw new NakedObjectException("No crumb found for " + task);
    }

    public Crumb[] getCrumbs() {
        int size = this.crumbs.size();
        Crumb[] taskList = new Crumb[size];
        for (int i = 0; i < this.crumbs.size(); ++i) {
            taskList[i] = (Crumb)this.crumbs.get(i);
        }
        return taskList;
    }

    public boolean[] isLinked() {
        int size = this.crumbs.size();
        boolean[] isLinked = new boolean[size];
        for (int i = size - 1; i >= 0; --i) {
            boolean isTask = this.crumbs.elementAt(i) instanceof TaskCrumb;
            boolean bl = isLinked[i] = i != size - 1;
            if (isTask) break;
        }
        return isLinked;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public String getMessage(int i) {
        return this.messages.get(i);
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public String getWarning(int i) {
        return this.warnings.get(i);
    }

    public void setMessagesAndWarnings(List<String> messages, List<String> warnings) {
        this.messages.clear();
        this.messages.addAll(messages);
        this.warnings.clear();
        this.warnings.addAll(warnings);
    }

    public void clearMessagesAndWarnings() {
        this.messages.clear();
        this.warnings.clear();
    }

    private boolean isTask() {
        int index = this.crumbs.size() - 1;
        return index >= 0 && this.crumbs.get(index) instanceof TaskCrumb;
    }

    public Request changeContext(int id) {
        while (this.crumbs.size() - 1 > id) {
            this.crumbs.pop();
        }
        Crumb c = (Crumb)this.crumbs.lastElement();
        return c.changeContext();
    }

    public void setSession(AuthenticationSession currentSession) {
        this.session = currentSession;
    }

    public AuthenticationSession getSession() {
        return this.session;
    }

    public void purge() {
        this.actionMap.clear();
        this.clearMessagesAndWarnings();
        HashMap<String, CollectionMapping> newCollectionMap = new HashMap<String, CollectionMapping>();
        HashMap<String, ObjectMapping> newObjectMap = new HashMap<String, ObjectMapping>();
        Iterator<HistoryEntry> elements = this.history.elements();
        while (elements.hasNext()) {
            HistoryEntry entry = elements.next();
            if (entry.type == 1) {
                ObjectMapping item = this.objectMap.get(entry.id);
                newObjectMap.put(entry.id, item);
                LOG.debug((Object)("copied object map " + entry.id + " for " + item));
                item.updateVersion();
                continue;
            }
            if (entry.type != 2) continue;
            CollectionMapping coll = this.collectionMap.get(entry.id);
            newCollectionMap.put(entry.id, coll);
            LOG.debug((Object)("copied collection map for " + coll));
            Enumeration e1 = coll.elements();
            while (e1.hasMoreElements()) {
                String id1 = (String)e1.nextElement();
                ObjectMapping item = this.objectMap.get(id1);
                if (item == null) continue;
                newObjectMap.put(id1, item);
                LOG.debug((Object)("copied object map " + id1 + " for " + item));
                item.updateVersion();
            }
        }
        this.collectionMap.clear();
        this.collectionMap.putAll(newCollectionMap);
        this.objectMap.clear();
        this.objectMap.putAll(newObjectMap);
        this.objectMap.putAll(this.serviceMap);
    }

    public void restoreAllObjectsToLoader() {
        Set<Map.Entry<String, ObjectMapping>> oidSet = this.objectMap.entrySet();
        Iterator<Map.Entry<String, ObjectMapping>> it = oidSet.iterator();
        while (it.hasNext()) {
            ObjectMapping mapping = it.next().getValue();
            mapping.restoreToLoader();
        }
    }

    public void listHistory(Context context, Block navigation) {
        this.history.listObjects(context, navigation);
    }

    public void addObjectToHistory(String idString) {
        this.history.addObject(idString);
    }

    public void addCollectionToHistory(String idString) {
        this.history.addCollection(idString);
    }

    public void init() {
        AdapterManager adapterManager = NakedObjectsContext.getPersistenceSession().getAdapterManager();
        List services = Context.getUserProfile().getPerspective().getServices();
        for (Object service : services) {
            NakedObject serviceAdapter = adapterManager.adapterFor(service);
            if (serviceAdapter == null) {
                LOG.warn((Object)("unable to find service: " + service + "; skipping"));
                continue;
            }
            this.mapObject(serviceAdapter);
        }
        this.serviceMap.putAll(this.objectMap);
    }

    public void updateVersion(NakedObject adapter) {
        if (adapter.isTransient()) {
            return;
        }
        String id = this.mapObject(adapter);
        if (id != null) {
            PersistentObjectMapping mapping = new PersistentObjectMapping(adapter);
            this.objectMap.put(id, mapping);
        }
    }

    public void processChanges() {
        List disposedObjects = NakedObjectsContext.getUpdateNotifier().getDisposedObjects();
        for (NakedObject nakedObject : disposedObjects) {
            ObjectMapping mapping = this.objectMapping(nakedObject);
            if (!this.objectMap.containsValue(mapping)) continue;
            String existingId = this.findExistingId(this.objectMap, mapping);
            this.history.remove(existingId);
            ArrayList relatedCrumbs = new ArrayList();
            for (Crumb crumb : this.getCrumbs()) {
            }
            for (Crumb crumb : relatedCrumbs) {
                this.crumbs.remove(crumb);
            }
            for (CollectionMapping collection : this.collectionMap.values()) {
                collection.remove(existingId);
            }
            this.objectMap.remove(existingId);
        }
    }

    private static UserProfile getUserProfile() {
        return NakedObjectsContext.getUserProfile();
    }
}

