/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.html.context;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.UnknownTypeException;
import org.nakedobjects.plugins.html.component.Block;
import org.nakedobjects.plugins.html.component.Component;
import org.nakedobjects.plugins.html.context.Context;
import org.nakedobjects.plugins.html.context.HistoryEntry;
import org.nakedobjects.runtime.context.NakedObjectsContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectHistory {
    private static final Logger LOG = Logger.getLogger(ObjectHistory.class);
    private static final int MAX = 8;
    private final List<HistoryEntry> history = new ArrayList<HistoryEntry>();

    private void add(HistoryEntry entry) {
        this.history.remove(entry);
        this.history.add(entry);
        LOG.debug((Object)("added to history: " + entry));
        if (this.history.size() > 8) {
            LOG.debug((Object)("purging from history: " + this.history.get(0)));
            this.history.remove(0);
        }
    }

    public void debug(DebugString debug) {
        for (int i = this.history.size() - 1; i >= 0; --i) {
            HistoryEntry object = this.history.get(i);
            debug.appendln(object.toString());
        }
    }

    public void listObjects(Context context, Block navigation) {
        Block taskBar = context.getComponentFactory().createBlock("history", null);
        taskBar.add(context.getComponentFactory().createHeading("History"));
        for (int i = this.history.size() - 1; i >= 0; --i) {
            Component icon;
            NakedObject object;
            HistoryEntry item = this.history.get(i);
            if (item.type == 1) {
                object = context.getMappedObject(item.id);
                NakedObjectsContext.getPersistenceSession().resolveImmediately(object);
                icon = context.getComponentFactory().createObjectIcon(object, item.id, "item");
            } else if (item.type == 2) {
                object = context.getMappedCollection(item.id);
                icon = context.getComponentFactory().createCollectionIcon(object, item.id);
            } else {
                throw new UnknownTypeException((Object)item);
            }
            taskBar.add(icon);
        }
        navigation.add(taskBar);
    }

    public void addObject(String idString) {
        this.add(new HistoryEntry(idString, 1));
    }

    public void addCollection(String idString) {
        this.add(new HistoryEntry(idString, 2));
    }

    public Iterator<HistoryEntry> elements() {
        return this.history.iterator();
    }

    public void remove(String existingId) {
        for (HistoryEntry entry : this.history) {
            if (!entry.id.equals(existingId)) continue;
            this.history.remove(entry);
            break;
        }
    }
}

