/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.html.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.plugins.html.component.html.HtmlComponentFactory;
import org.nakedobjects.plugins.html.component.html.LogonFormPage;
import org.nakedobjects.plugins.html.context.Context;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.AuthenticationRequestPassword;
import org.nakedobjects.runtime.authentication.standard.exploration.AuthenticationRequestExploration;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.system.internal.monitor.Monitor;
import org.nakedobjects.webapp.WebAppConstants;
import org.nakedobjects.webapp.auth.AuthenticationSessionLookupStrategyDefault;

public class LogonServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(LogonServlet.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean sessionValid;
        AuthenticationSession authSession = new AuthenticationSessionLookupStrategyDefault().lookup((ServletRequest)request, (ServletResponse)response);
        if (authSession != null && (sessionValid = NakedObjectsContext.getAuthenticationManager().isSessionValid(authSession))) {
            this.loggedIn(response, authSession.getUserName());
            return;
        }
        String user = request.getParameter("username");
        String password = request.getParameter("password");
        if (user == null && !NakedObjectsContext.getDeploymentType().isExploring()) {
            this.prompt(response, "", "", "");
            return;
        }
        authSession = this.authenticate(user, password);
        if (authSession == null) {
            this.prompt(response, user, password, "error");
            return;
        }
        HttpSession httpSession = request.getSession(true);
        httpSession.setAttribute(WebAppConstants.HTTP_SESSION_AUTHENTICATION_SESSION_KEY, (Object)authSession);
        Context context = new Context(new HtmlComponentFactory());
        context.setSession(authSession);
        authSession.setAttribute("nof-context", (Object)context);
        LOG.info((Object)("created session: " + httpSession));
        this.loggedIn(response, user);
    }

    private AuthenticationSession authenticate(String user, String password) {
        Object request = NakedObjectsContext.getDeploymentType() == DeploymentType.EXPLORATION ? new AuthenticationRequestExploration() : new AuthenticationRequestPassword(user, password);
        return LogonServlet.getAuthenticationManager().authenticate((AuthenticationRequest)request);
    }

    private void prompt(HttpServletResponse response, String user, String password, String message) throws IOException {
        response.setContentType("text/html");
        HtmlComponentFactory factory = new HtmlComponentFactory();
        LogonFormPage page = factory.createLogonPage(user, password);
        page.write(response.getWriter());
    }

    private void loggedIn(HttpServletResponse response, String user) throws IOException {
        Monitor.addEvent((String)"Web", (String)("Logon - " + user));
        response.sendRedirect("start.app");
    }

    private static AuthenticationManager getAuthenticationManager() {
        return NakedObjectsContext.getAuthenticationManager();
    }
}

