/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.html.task;

import java.util.List;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionParameter;
import org.nakedobjects.metamodel.spec.feature.ParseableEntryActionParameter;
import org.nakedobjects.plugins.html.component.Page;
import org.nakedobjects.plugins.html.context.Context;
import org.nakedobjects.plugins.html.task.Task;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.transaction.messagebroker.MessageBroker;

public final class MethodTask
extends Task {
    private final NakedObjectAction action;

    protected MethodTask(Context context, NakedObject target, NakedObjectAction action) {
        super(context, action.getName(), action.getDescription(), target, action.getParameterCount());
        this.action = action;
        NakedObjectActionParameter[] parameters = action.getParameters();
        int len = parameters.length;
        for (int i = 0; i < len; ++i) {
            this.names[i] = parameters[i].getName();
            this.descriptions[i] = parameters[i].getDescription();
            this.fieldSpecifications[i] = parameters[i].getSpecification();
            this.optional[i] = parameters[i].isOptional();
            if (!parameters[i].getSpecification().isParseable()) continue;
            ParseableEntryActionParameter valueParameter = (ParseableEntryActionParameter)parameters[i];
            this.noLines[i] = valueParameter.getNoLines();
            this.wraps[i] = valueParameter.canWrap();
            this.maxLength[i] = valueParameter.getMaximumLength();
            this.typicalLength[i] = valueParameter.getTypicalLineLength();
        }
        NakedObject[] defaultParameterValues = action.getDefaults(target);
        for (int i = 0; i < this.names.length; ++i) {
            if (defaultParameterValues[i] == null) {
                if (action.isContributed()) {
                    this.initialState[i] = target;
                    continue;
                }
                this.initialState[i] = null;
                continue;
            }
            this.initialState[i] = defaultParameterValues[i];
        }
    }

    public void checkForValidity(Context context) {
        NakedObject[] parameters = this.getEntries(context);
        NakedObject target = this.getTarget(context);
        Consent consent = this.action.isProposedArgumentSetValid(target, parameters);
        this.error = consent.getReason();
    }

    public NakedObject completeTask(Context context, Page page) {
        NakedObject[] parameters = this.getEntries(context);
        NakedObject target = this.getTarget(context);
        NakedObject result = this.action.execute(target, parameters);
        MessageBroker broker = NakedObjectsContext.getMessageBroker();
        List messages = broker.getMessages();
        List warnings = broker.getWarnings();
        context.setMessagesAndWarnings(messages, warnings);
        return result;
    }

    public void debug(DebugString debug) {
        debug.appendln("action: " + this.action);
        super.debug(debug);
    }

    protected NakedObject[][] getOptions(Context context, int from, int len) {
        NakedObject[][] allOptions = this.action.getChoices(this.getTarget(context));
        NakedObject[][] options = new NakedObject[len][];
        int i = from;
        for (int j = 0; j < len; ++j) {
            options[j] = allOptions[i];
            ++i;
        }
        return options;
    }

    public boolean collectParameters() {
        int expectedNoParameters = this.action.isContributed() ? 1 : 0;
        return this.action.getParameterCount() == expectedNoParameters;
    }
}

