/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.html.viewer;

import org.nakedobjects.metamodel.commons.lang.MapUtils;
import org.nakedobjects.plugins.html.servlet.ControllerServlet;
import org.nakedobjects.plugins.html.servlet.LogonServlet;
import org.nakedobjects.runtime.viewer.NakedObjectsViewer;
import org.nakedobjects.runtime.viewer.NakedObjectsViewerInstallerAbstract;
import org.nakedobjects.runtime.web.EmbeddedWebViewer;
import org.nakedobjects.runtime.web.WebAppSpecification;
import org.nakedobjects.webapp.NakedObjectsSessionFilter;
import org.nakedobjects.webapp.StaticContentFilter;
import org.nakedobjects.webapp.servlets.ResourceServlet;

public class HtmlViewerInstaller
extends NakedObjectsViewerInstallerAbstract {
    private static final String LOGON_PAGE = "logon.app";
    private static final String LOGON_PAGE_MAPPED = "/logon.app";
    private static final String[] STATIC_CONTENT = new String[]{"*.gif", "*.png", "*.jpg", "*.css"};
    private static final String DYNAMIC_CONTENT = "*.app";

    public HtmlViewerInstaller() {
        super("html");
    }

    public NakedObjectsViewer doCreateViewer() {
        return new EmbeddedWebViewer(){

            public WebAppSpecification getWebAppSpecification() {
                WebAppSpecification webAppSpec = new WebAppSpecification();
                webAppSpec.addFilterSpecification(NakedObjectsSessionFilter.class, MapUtils.asMap((String[])new String[]{"logonPage", HtmlViewerInstaller.LOGON_PAGE_MAPPED}), new String[]{HtmlViewerInstaller.DYNAMIC_CONTENT});
                webAppSpec.addServletSpecification(LogonServlet.class, new String[]{HtmlViewerInstaller.LOGON_PAGE_MAPPED});
                webAppSpec.addServletSpecification(ControllerServlet.class, new String[]{HtmlViewerInstaller.DYNAMIC_CONTENT});
                webAppSpec.addFilterSpecification(StaticContentFilter.class, STATIC_CONTENT);
                webAppSpec.addServletSpecification(ResourceServlet.class, STATIC_CONTENT);
                String resourceBaseDir = 1.getConfiguration().getString("nakedobjects.viewer.html.resourceBase");
                if (resourceBaseDir != null) {
                    webAppSpec.addResourcePath(resourceBaseDir);
                }
                webAppSpec.addResourcePath("./src/main/resources");
                webAppSpec.addResourcePath("./src/main/webapp");
                webAppSpec.addResourcePath("./web");
                webAppSpec.addResourcePath(".");
                webAppSpec.addWelcomeFile(HtmlViewerInstaller.LOGON_PAGE);
                webAppSpec.setLogHint("open a web browser and browse to logon.app to connect");
                return webAppSpec;
            }
        };
    }
}

